/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import java.util.List;
import java.util.Set;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.util.Symbol;

public class TransformTopN
extends TransformCopy {
    private static final int defaultTopNSortingThreshold = 1000;
    public static final Symbol externalSortBufferSize = ARQ.topNSortingThreshold;

    @Override
    public Op transform(OpSlice opSlice, Op inSubOp) {
        List<SortCondition> sortConditions;
        Set<Var> orderVars;
        Op subOp = inSubOp;
        if (opSlice.getLength() == Long.MIN_VALUE) {
            return this.doNothing(opSlice, inSubOp);
        }
        long limit = opSlice.getLength();
        long offset = opSlice.getStart() != Long.MIN_VALUE ? opSlice.getStart() : 0L;
        long N = limit + offset;
        int threshold = 1000;
        Number x = (Number)ARQ.getContext().get(ARQ.topNSortingThreshold);
        if (x != null) {
            threshold = x.intValue();
        }
        if (N >= (long)threshold) {
            return this.doNothing(opSlice, inSubOp);
        }
        boolean distinct = false;
        boolean reduce = false;
        if (subOp instanceof OpDistinct) {
            distinct = true;
            subOp = ((Op1)subOp).getSubOp();
        } else if (subOp instanceof OpReduced) {
            distinct = true;
            subOp = ((Op1)subOp).getSubOp();
        }
        List<Var> projection = null;
        if (subOp instanceof OpProject) {
            OpProject opProject = (OpProject)subOp;
            projection = opProject.getVars();
            subOp = opProject.getSubOp();
        }
        if (!(subOp instanceof OpOrder)) {
            return this.doNothing(opSlice, inSubOp);
        }
        OpOrder opOrder = (OpOrder)subOp;
        subOp = opOrder.getSubOp();
        if ((reduce || distinct) && projection != null && !projection.containsAll(orderVars = ExprVars.getVarsMentioned(sortConditions = opOrder.getConditions()))) {
            return this.doNothing(opSlice, inSubOp);
        }
        Op newOp = subOp;
        if ((reduce || distinct) && projection != null) {
            newOp = new OpProject(newOp, projection);
        }
        if (distinct) {
            newOp = OpDistinct.create(newOp);
        }
        if (reduce) {
            newOp = OpReduced.create(newOp);
        }
        newOp = new OpTopN(newOp, (int)N, opOrder.getConditions());
        if (!reduce && !distinct && projection != null) {
            newOp = new OpProject(newOp, projection);
        }
        if (opSlice.getStart() > 0L) {
            newOp = new OpSlice(newOp, opSlice.getStart(), Long.MIN_VALUE);
        }
        return newOp;
    }

    private Op doNothing(OpSlice opSlice, Op subOp) {
        return super.transform(opSlice, subOp);
    }
}

