/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.walker;

import java.util.Objects;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.OpVisitorBase;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.walker.ApplyTransformVisitor;
import org.apache.jena.sparql.algebra.walker.WalkerVisitor;
import org.apache.jena.sparql.algebra.walker.WalkerVisitorSkipService;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.ExprVisitorBase;

public class Walker {
    private static OpVisitor nullOpVisitor = new OpVisitorBase();
    private static ExprVisitor nullExprVisitor = new ExprVisitorBase();
    private static Transform nullOpTransform = new TransformCopy();
    private static ExprTransform nullExprTransform = new ExprTransformCopy();

    public static void walk(Op op, OpVisitor opVisitor) {
        Objects.requireNonNull(opVisitor);
        Walker.walk(op, opVisitor, null);
    }

    public static void walk(Op op, OpVisitor opVisitor, ExprVisitor exprVisitor) {
        Walker.walk(op, opVisitor, exprVisitor, null, null);
    }

    public static void walk(Op op, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            return;
        }
        Walker.walk$(op, opVisitor, exprVisitor, beforeVisitor, afterVisitor);
    }

    public static void walkSkipService(Op op, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            return;
        }
        Walker.walkSkipService$(op, opVisitor, exprVisitor, beforeVisitor, afterVisitor);
    }

    private static void walk$(Op op, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        WalkerVisitor wv = Walker.createWalker(opVisitor, exprVisitor, beforeVisitor, afterVisitor);
        Walker.walk$(op, wv);
    }

    private static void walkSkipService$(Op op, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        WalkerVisitor wv = Walker.createWalkerSkipService(opVisitor, exprVisitor, beforeVisitor, afterVisitor);
        Walker.walk$(op, wv);
    }

    private static void walk$(Op op, WalkerVisitor walker) {
        walker.walk(op);
    }

    public static void walk(Expr expr, ExprVisitor exprVisitor) {
        Objects.requireNonNull(exprVisitor);
        Walker.walk(expr, null, exprVisitor);
    }

    public static void walk(Expr expr, OpVisitor opVisitor, ExprVisitor exprVisitor) {
        Walker.walk(expr, opVisitor, exprVisitor, null, null);
    }

    public static void walk(Expr expr, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (expr == null) {
            return;
        }
        Walker.walk$(expr, opVisitor, exprVisitor, beforeVisitor, afterVisitor);
    }

    private static void walk$(Expr expr, OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        WalkerVisitor wv = Walker.createWalker(opVisitor, exprVisitor, beforeVisitor, afterVisitor);
        Walker.walk$(expr, wv);
    }

    private static void walk$(Expr expr, WalkerVisitor walker) {
        walker.walk(expr);
    }

    public static void walk(ExprList exprList, ExprVisitor exprVisitor) {
        Walker.walk(exprList, null, exprVisitor);
    }

    public static void walk(ExprList exprList, OpVisitor opVisitor, ExprVisitor exprVisitor) {
        if (exprList == null) {
            return;
        }
        Objects.requireNonNull(exprVisitor);
        exprList.forEach(e2 -> Walker.walk(e2, opVisitor, exprVisitor));
    }

    public static void walk(VarExprList varExprList, ExprVisitor exprVisitor) {
        Objects.requireNonNull(exprVisitor);
        Walker.walk(varExprList, null, exprVisitor);
    }

    public static void walk(VarExprList varExprList, OpVisitor opVisitor, ExprVisitor exprVisitor) {
        if (varExprList == null) {
            return;
        }
        varExprList.forEachExpr((v, e2) -> Walker.walk(e2, opVisitor, exprVisitor));
    }

    public static WalkerVisitor createWalker(OpVisitor opVisitor, ExprVisitor exprVisitor) {
        return Walker.createWalker(opVisitor, exprVisitor, null, null);
    }

    public static WalkerVisitor createWalker(OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (opVisitor == null) {
            opVisitor = nullOpVisitor;
        }
        if (exprVisitor == null) {
            exprVisitor = nullExprVisitor;
        }
        return new WalkerVisitor(opVisitor, exprVisitor, beforeVisitor, afterVisitor);
    }

    public static WalkerVisitor createWalkerSkipService(OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (opVisitor == null) {
            opVisitor = nullOpVisitor;
        }
        if (exprVisitor == null) {
            exprVisitor = nullExprVisitor;
        }
        return new WalkerVisitorSkipService(opVisitor, exprVisitor, beforeVisitor, afterVisitor);
    }

    public static Op transform(Op op, Transform transform) {
        return Walker.transform(op, transform, null);
    }

    public static Op transform(Op op, Transform opTransform, ExprTransform exprTransform) {
        ApplyTransformVisitor v = Walker.createTransformer(opTransform, exprTransform);
        return Walker.transform(op, v);
    }

    public static Op transform(Op op, Transform opTransform, ExprTransform exprTransform, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ApplyTransformVisitor v = Walker.createTransformer(opTransform, exprTransform, beforeVisitor, afterVisitor);
        return Walker.transform(op, v, beforeVisitor, afterVisitor);
    }

    public static Op transform(Op op, ApplyTransformVisitor v) {
        return Walker.transform(op, v, null, null);
    }

    public static Op transform(Op op, ApplyTransformVisitor v, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        Walker.walk(op, (OpVisitor)v, (ExprVisitor)v, beforeVisitor, afterVisitor);
        return v.opResult();
    }

    public static Op transformSkipService(Op op, ApplyTransformVisitor v, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        Walker.walkSkipService(op, v, v, beforeVisitor, afterVisitor);
        return v.opResult();
    }

    public static Expr transform(Expr expr, ExprTransform exprTransform) {
        return Walker.transform(expr, null, exprTransform);
    }

    public static Expr transform(Expr expr, Transform opTransform, ExprTransform exprTransform) {
        ApplyTransformVisitor v = Walker.createTransformer(opTransform, exprTransform);
        return Walker.transform(expr, v);
    }

    public static Expr transform(Expr expr, Transform opTransform, ExprTransform exprTransform, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ApplyTransformVisitor v = Walker.createTransformer(opTransform, exprTransform, beforeVisitor, afterVisitor);
        return Walker.transform(expr, v, beforeVisitor, afterVisitor);
    }

    public static Expr transform(Expr expr, ApplyTransformVisitor v) {
        Walker.walk(expr, (OpVisitor)v, (ExprVisitor)v, null, null);
        return v.exprResult();
    }

    public static Expr transform(Expr expr, ApplyTransformVisitor v, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        Walker.walk(expr, (OpVisitor)v, (ExprVisitor)v, beforeVisitor, afterVisitor);
        return v.exprResult();
    }

    public static ApplyTransformVisitor createTransformer(Transform opTransform, ExprTransform exprTransform) {
        return Walker.createTransformer(opTransform, exprTransform, null, null);
    }

    public static ApplyTransformVisitor createTransformer(Transform opTransform, ExprTransform exprTransform, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (opTransform == null) {
            opTransform = nullOpTransform;
        }
        if (exprTransform == null) {
            exprTransform = nullExprTransform;
        }
        return new ApplyTransformVisitor(opTransform, exprTransform, true, null, null);
    }
}

