/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.stream.Stream;
import org.apache.jena.atlas.lib.persistent.PersistentSet;
import org.apache.jena.atlas.lib.tuple.TConsumer3;
import org.apache.jena.atlas.lib.tuple.TFunction3;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.mem.FourTupleMap;
import org.apache.jena.sparql.core.mem.PMapTupleTable;
import org.apache.jena.sparql.core.mem.TripleTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMapTripleTable
extends PMapTupleTable<FourTupleMap.ThreeTupleMap, Triple, TConsumer3<Node>>
implements TripleTable {
    private static final Logger log = LoggerFactory.getLogger(PMapTripleTable.class);
    private TFunction3<Node, Stream<Triple>> find = (first, second, third) -> {
        this.debug("Querying on three-tuple pattern: {} {} {} .", first, second, third);
        FourTupleMap.ThreeTupleMap threeTuples = (FourTupleMap.ThreeTupleMap)((Object)((Object)this.local().get()));
        if (this.isConcrete((Node)first)) {
            this.debug("Using a specific first slot value.", new Object[0]);
            return threeTuples.get(first).map((? super T twoTuples) -> {
                if (this.isConcrete((Node)second)) {
                    this.debug("Using a specific second slot value.", new Object[0]);
                    return twoTuples.get(second).map((? super T oneTuples) -> {
                        if (this.isConcrete((Node)third)) {
                            this.debug("Using a specific third slot value.", new Object[0]);
                            return oneTuples.contains(third) ? Stream.of(this.unmap((Node)first, (Node)second, (Node)third)) : Stream.empty();
                        }
                        this.debug("Using a wildcard third slot value.", new Object[0]);
                        return oneTuples.stream().map((? super T slot3) -> this.unmap((Node)first, (Node)second, (Node)slot3));
                    }).orElse(Stream.empty());
                }
                this.debug("Using wildcard second and third slot values.", new Object[0]);
                return twoTuples.flatten((slot2, oneTuples) -> oneTuples.stream().map((? super T slot3) -> this.unmap((Node)first, (Node)slot2, (Node)slot3)));
            }).orElse(Stream.empty());
        }
        this.debug("Using a wildcard for all slot values.", new Object[0]);
        return threeTuples.flatten((slot1, twoTuples) -> twoTuples.flatten((slot2, oneTuples) -> oneTuples.stream().map((? super T slot3) -> this.unmap((Node)slot1, (Node)slot2, (Node)slot3))));
    };

    public PMapTripleTable(String order) {
        this("SPO", order);
    }

    public PMapTripleTable(String canonical, String order) {
        this(canonical + "->" + order, TupleMap.create((String)canonical, (String)order));
    }

    public PMapTripleTable(String tableName, TupleMap order) {
        super(tableName, order);
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected FourTupleMap.ThreeTupleMap initial() {
        return new FourTupleMap.ThreeTupleMap();
    }

    @Override
    public void add(Triple t) {
        this.map(this.add()).accept(t);
    }

    @Override
    public void delete(Triple t) {
        this.map(this.delete()).accept(t);
    }

    @Override
    public Stream<Triple> find(Node s, Node p, Node o) {
        return (Stream)this.map(this.find).apply((Object)s, (Object)p, (Object)o);
    }

    @Override
    protected TConsumer3<Node> add() {
        return (first, second, third) -> {
            this.debug("Adding three-tuple {} {} {}", first, second, third);
            FourTupleMap.ThreeTupleMap threeTuples = (FourTupleMap.ThreeTupleMap)((Object)((Object)this.local().get()));
            FourTupleMap.TwoTupleMap twoTuples = threeTuples.get(first).orElse(new FourTupleMap.TwoTupleMap());
            PersistentSet oneTuples = twoTuples.get(second).orElse(PersistentSet.empty());
            oneTuples = oneTuples.plus(third);
            twoTuples = (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(second)).plus(second, oneTuples);
            this.local().set(((FourTupleMap.ThreeTupleMap)threeTuples.minus(first)).plus(first, (Object)twoTuples));
        };
    }

    @Override
    protected TConsumer3<Node> delete() {
        return (first, second, third) -> {
            this.debug("Deleting three-tuple {} {} {}", first, second, third);
            FourTupleMap.ThreeTupleMap threeTuples = (FourTupleMap.ThreeTupleMap)((Object)((Object)this.local().get()));
            threeTuples.get(first).ifPresent(twoTuples -> twoTuples.get(second).ifPresent(oneTuples -> {
                if (oneTuples.contains(third)) {
                    FourTupleMap.TwoTupleMap newTwoTuples = (oneTuples = oneTuples.minus(third)).asSet().isEmpty() ? (FourTupleMap.TwoTupleMap)twoTuples.minus(second) : (FourTupleMap.TwoTupleMap)((FourTupleMap.TwoTupleMap)twoTuples.minus(second)).plus(second, oneTuples);
                    this.debug("Setting transactional index to new value.", new Object[0]);
                    FourTupleMap.ThreeTupleMap newThreeTuples = twoTuples.asMap().isEmpty() ? (FourTupleMap.ThreeTupleMap)threeTuples.minus(first) : (FourTupleMap.ThreeTupleMap)((FourTupleMap.ThreeTupleMap)threeTuples.minus(first)).plus(first, (Object)newTwoTuples);
                    this.local().set(newThreeTuples);
                }
            }));
        };
    }
}

