/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.lang.ParserBase;
import org.apache.jena.sparql.lang.SyntaxVarScope;
import org.apache.jena.sparql.modify.UpdateSink;
import org.apache.jena.sparql.modify.request.QuadAcc;
import org.apache.jena.sparql.modify.request.QuadDataAccSink;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.modify.request.UpdateVisitor;
import org.apache.jena.sparql.modify.request.UpdateVisitorBase;
import org.apache.jena.sparql.util.LabelToNodeMap;
import org.apache.jena.update.Update;

public class SPARQLParserBase
extends ParserBase {
    private Deque<Query> stack = new ArrayDeque<Query>();
    protected Query query;
    private UpdateSink sink = null;
    private boolean oldBNodesAreVariables;
    private boolean oldBNodesAreAllowed;
    private int queryLevel = -1;
    private Deque<Set<String>> stackPreviousLabels = new ArrayDeque<Set<String>>();
    private Deque<LabelToNodeMap> stackCurrentLabels = new ArrayDeque<LabelToNodeMap>();
    private static UpdateVisitor v = new UpdateVisitorBase(){

        @Override
        public void visit(UpdateModify mod) {
            SyntaxVarScope.check(mod.getWherePattern());
        }
    };
    private List<Var> variables = null;
    private List<Binding> values = null;
    private int currentColumn = -1;

    protected SPARQLParserBase() {
    }

    public void setQuery(Query q) {
        this.query = q;
        this.setPrologue(q);
    }

    public Query getQuery() {
        return this.query;
    }

    public void setUpdateSink(UpdateSink sink) {
        this.sink = sink;
        this.query = new Query();
        this.setPrologue(sink.getPrologue());
    }

    protected void startQuery() {
    }

    protected void finishQuery() {
    }

    protected void startUpdateRequest() {
    }

    protected void finishUpdateRequest() {
    }

    protected void startUpdateOperation() {
    }

    protected void finishUpdateOperation() {
    }

    protected void startModifyUpdate() {
    }

    protected void finishModifyUpdate() {
    }

    protected void startDataInsert(QuadDataAccSink qd, int line, int col) {
        this.oldBNodesAreVariables = this.getBNodesAreVariables();
        this.setBNodesAreVariables(false);
        this.activeLabelMap.clear();
    }

    protected void finishDataInsert(QuadDataAccSink qd, int line, int col) {
        this.previousLabels.addAll(this.activeLabelMap.getLabels());
        this.activeLabelMap.clear();
        this.setBNodesAreVariables(this.oldBNodesAreVariables);
    }

    protected void startDataDelete(QuadDataAccSink qd, int line, int col) {
        this.oldBNodesAreAllowed = this.getBNodesAreAllowed();
        this.setBNodesAreAllowed(false);
    }

    protected void finishDataDelete(QuadDataAccSink qd, int line, int col) {
        this.setBNodesAreAllowed(this.oldBNodesAreAllowed);
    }

    protected void startWherePattern() {
        ++this.queryLevel;
        if (this.queryLevel == 0) {
            this.pushLabelState();
            this.clearLabelState();
        }
    }

    protected void finishWherePattern() {
        if (this.queryLevel == 0) {
            this.popLabelState();
        }
        --this.queryLevel;
    }

    protected void startInsertTemplate(QuadAcc qd, int line, int col) {
        this.oldBNodesAreVariables = this.getBNodesAreVariables();
        this.setBNodesAreVariables(false);
        this.pushLabelState();
    }

    protected void finishInsertTemplate(QuadAcc qd, int line, int col) {
        this.popLabelState();
        this.setBNodesAreVariables(this.oldBNodesAreVariables);
    }

    protected void startDeleteTemplate(QuadAcc qd, int line, int col) {
        this.oldBNodesAreAllowed = this.getBNodesAreAllowed();
        this.setBNodesAreAllowed(false);
    }

    protected void finishDeleteTemplate(QuadAcc qd, int line, int col) {
        this.setBNodesAreAllowed(this.oldBNodesAreAllowed);
    }

    protected void emitUpdate(Update update) {
        if (null != update) {
            this.verifyUpdate(update);
            this.sink.send(update);
        }
    }

    private void verifyUpdate(Update update) {
        update.visit(v);
    }

    protected QuadDataAccSink createInsertDataSink() {
        return this.sink.createInsertDataSink();
    }

    protected QuadDataAccSink createDeleteDataSink() {
        return this.sink.createDeleteDataSink();
    }

    protected void pushQuery() {
        if (this.query == null) {
            throw new ARQInternalErrorException("Parser query object is null");
        }
        this.stack.push(this.query);
    }

    protected void startSubSelect(int line, int col) {
        this.pushQuery();
        this.query = this.newSubQuery(this.getPrologue());
    }

    protected Query newSubQuery(Prologue progloue) {
        return new Query(this.getPrologue());
    }

    protected void popQuery() {
        this.query = this.stack.pop();
    }

    protected Query endSubSelect(int line, int column) {
        Query subQuery = this.query;
        if (!subQuery.isSelectType()) {
            SPARQLParserBase.throwParseException("Subquery not a SELECT query", line, column);
        }
        this.popQuery();
        return subQuery;
    }

    protected void startValuesClause(int line, int col) {
        this.variables = new ArrayList<Var>();
        this.values = new ArrayList<Binding>();
    }

    protected void finishValuesClause(int line, int col) {
        this.getQuery().setValuesDataBlock(this.variables, this.values);
    }

    protected void startInlineData(List<Var> vars, List<Binding> rows, int line, int col) {
        this.variables = vars;
        this.values = rows;
    }

    protected void finishInlineData(int line, int col) {
    }

    private BindingMap currentValueRow() {
        return (BindingMap)this.values.get(this.values.size() - 1);
    }

    protected void emitDataBlockVariable(Var v) {
        this.variables.add(v);
    }

    protected void startDataBlockValueRow(int line, int col) {
        this.values.add(BindingFactory.create());
        this.currentColumn = -1;
    }

    protected void emitDataBlockValue(Node n, int line, int col) {
        ++this.currentColumn;
        if (this.currentColumn >= this.variables.size()) {
            return;
        }
        Var v = this.variables.get(this.currentColumn);
        if (n != null) {
            this.currentValueRow().add(v, n);
        }
    }

    protected void finishDataBlockValueRow(int line, int col) {
        if (this.currentColumn + 1 != this.variables.size()) {
            String msg = String.format("Mismatch: %d variables but %d values", this.variables.size(), this.currentColumn + 1);
            msg = QueryParseException.formatMessage(msg, line, col);
            throw new QueryParseException(msg, line, col);
        }
    }

    private void pushLabelState() {
        this.stackPreviousLabels.push(this.previousLabels);
        this.stackCurrentLabels.push(this.activeLabelMap);
        this.previousLabels = new HashSet();
        this.activeLabelMap.clear();
    }

    private void popLabelState() {
        this.previousLabels = this.stackPreviousLabels.pop();
        this.activeLabelMap = this.stackCurrentLabels.pop();
    }

    private void clearLabelState() {
        this.activeLabelMap.clear();
        this.previousLabels.clear();
    }
}

