/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.editor;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.mule.weave.v2.editor.WeaveUnitTest;
import org.mule.weave.v2.editor.WeaveUnitTestAddition;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.AstNodeHelper$;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallParametersNode;
import org.mule.weave.v2.parser.ast.header.directives.FunctionDirectiveNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class WeaveUnitTestSuite$ {
    public static WeaveUnitTestSuite$ MODULE$;

    static {
        new WeaveUnitTestSuite$();
    }

    public String initialTest(FunctionDirectiveNode node, String moduleName) {
        WeaveUnitTest test = new WeaveUnitTest(node);
        return this.createInitialTest(node.variable().name(), moduleName, (Seq<WeaveUnitTest>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeaveUnitTest[]{test}))));
    }

    private String createInitialTest(String functionName, String moduleName, Seq<WeaveUnitTest> tests) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("%dw 2.0\n       |import * from dw::test::Tests\n       |import * from dw::test::Asserts\n       |\n       |import ").append(functionName).append(" from ").append(moduleName).append("\n       |---\n       |\"Test ").append(functionName).append("\" describedBy [\n       |").append(((TraversableOnce)tests.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("]\n       |").toString())).stripMargin();
    }

    public Option<WeaveUnitTestAddition> fromExisting(FunctionDirectiveNode node, String name, AstNode testAst) {
        WeaveUnitTest test = new WeaveUnitTest(node);
        return AstNodeHelper$.MODULE$.find(testAst, (Function1<AstNode, Object>)(Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WeaveUnitTestSuite$.$anonfun$fromExisting$1(x0$1))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AstNode astNode = x0$2;
            if (!(astNode instanceof FunctionCallNode)) return None$.MODULE$;
            FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
            AstNode astNode2 = functionCallNode.function();
            FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
            if (!(astNode2 instanceof VariableReferenceNode)) return None$.MODULE$;
            VariableReferenceNode variableReferenceNode = (VariableReferenceNode)astNode2;
            NameIdentifier nameIdentifier = variableReferenceNode.variable();
            if (nameIdentifier == null) return None$.MODULE$;
            String string = nameIdentifier.name();
            if (!"describedBy".equals(string)) return None$.MODULE$;
            if (functionCallParametersNode == null) return None$.MODULE$;
            Seq<AstNode> seq = functionCallParametersNode.args();
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty()) return None$.MODULE$;
            if (some.get() == null) return None$.MODULE$;
            if (((SeqLike)some.get()).lengthCompare(2) != 0) return None$.MODULE$;
            AstNode array = (AstNode)((SeqLike)some.get()).apply(1);
            return new Some((Object)BoxesRunTime.boxToInteger((int)array.location().endPosition().line()));
        }).map((Function1 & Serializable & scala.Serializable)x$2 -> WeaveUnitTestSuite$.$anonfun$fromExisting$3(test, BoxesRunTime.unboxToInt((Object)x$2)));
    }

    public String expectedPath(FunctionDirectiveNode node, String moduleName) {
        String modPath = moduleName.replace(NameIdentifier$.MODULE$.SEPARATOR(), File.separator);
        String filePath = new StringBuilder(8).append(node.variable().name().replace(NameIdentifier$.MODULE$.SEPARATOR(), File.separator)).append("Test.dwl").toString();
        return ((Object)Paths.get(modPath, filePath)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$fromExisting$1(AstNode x0$1) {
        AstNode astNode = x0$1;
        if (!(astNode instanceof FunctionCallNode)) return false;
        FunctionCallNode functionCallNode = (FunctionCallNode)astNode;
        AstNode astNode2 = functionCallNode.function();
        FunctionCallParametersNode functionCallParametersNode = functionCallNode.args();
        if (!(astNode2 instanceof VariableReferenceNode)) return false;
        VariableReferenceNode variableReferenceNode = (VariableReferenceNode)astNode2;
        NameIdentifier nameIdentifier = variableReferenceNode.variable();
        if (nameIdentifier == null) return false;
        String string = nameIdentifier.name();
        if (!"describedBy".equals(string)) return false;
        if (functionCallParametersNode == null) return false;
        return true;
    }

    public static final /* synthetic */ WeaveUnitTestAddition $anonfun$fromExisting$3(WeaveUnitTest test$1, int x$2) {
        return new WeaveUnitTestAddition(test$1.toString(), x$2);
    }

    private WeaveUnitTestSuite$() {
        MODULE$ = this;
    }
}

