import wait as runtimeWait from dw::Runtime
import mergeWith from dw::core::Objects

import HttpClientResult from dw::http::Types
import HttpCustomOptions, request from dw::http::Client

import * from bat::core::Helpers
import * from bat::Types

import executeStep0, runSequence from bat::core::Executors
import println, red from bat::core::Console

// This file should only contain the DSL of testing. Any other function should be placed in other module(s)

// DSL =================================================================================================================

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `GET` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  GET `https://httpbin.org/get` with {}
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "GET",
*      "url": "https://httpbin.org/get"
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "GET",
*      "url": "https://httpbin.org/get",
*      "path": "/get",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/get\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/get"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun GET(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'GET')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `POST` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  POST `https://httpbin.org/post` with {
*   body: {
*       name: "Jack"
*   }
*  }
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "POST",
*      "url": "https://httpbin.org/post",
*      "body": "{\n  \"name\": \"Jack\"\n}",
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "POST",
*      "url": "https://httpbin.org/post",
*      "path": "/post",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/post\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/post"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun POST(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'POST')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `PUT` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  PUT `https://httpbin.org/patch` with {
*   body: {
*       name: "Jack"
*   }
*  }
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "PUT",
*      "url": "https://httpbin.org/put",
*      "body": "{\n  \"name\": \"Jack\"\n}",
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "put",
*      "url": "https://httpbin.org/put",
*      "path": "/put",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/put\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/put"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun PUT(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'PUT')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `PATCH` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  PATCH `https://httpbin.org/patch` with {
*   body: {
*       name: "Jack"
*   }
*  }
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "patch",
*      "url": "https://httpbin.org/patch",
*      "body": "{\n  \"name\": \"Jack\"\n}",
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "patch",
*      "url": "https://httpbin.org/patch",
*      "path": "/patch",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/patch\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/patch"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun PATCH(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'PATCH')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `OPTIONS` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  OPTIONS `https://httpbin.org/options` with {}
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "OPTIONS",
*      "url": "https://httpbin.org/options"
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "OPTIONS",
*      "url": "https://httpbin.org/options",
*      "path": "/options",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/options\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/options"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun OPTIONS(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'OPTIONS')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `DELETE` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  DELETE `https://httpbin.org/delete` with {}
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "DELETE",
*      "url": "https://httpbin.org/delete"
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "DELETE",
*      "url": "https://httpbin.org/delete",
*      "path": "/delete",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/delete\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/delete"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun DELETE(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'DELETE')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `TRACE` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  TRACE `https://httpbin.org/trace` with {}
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "TRACE",
*      "url": "https://httpbin.org/trace"
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "TRACE",
*      "url": "https://httpbin.org/trace",
*      "path": "/trace",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/trace\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/trace"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun TRACE(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'TRACE')

/**
*
*  Executes the request and creates an HTTP test block. Including the request and the response.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | An array of the literal parts of the URL
* | interpolation | An array of the expressions that are going to be interpolated to build the request URL
* |===
*
* The best way to call this function is using custom string interpolation that is using backticks.
* By using this method, the function will receive the two arrays of literals and expressions.
*
* === Example
*
* This example shows how the `CONNECT` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
*
* ---
*
* describe `Hello World Suite` in [
*  CONNECT `https://httpbin.org/connect` with {}
*]
*
* ----
*
* ==== Output
*
* [source,Json,linenums]
* ----
* {
*    "options": {
*      "headers": {},
*      "method": "CONNECT",
*      "url": "https://httpbin.org/connect"
*    },
*    "request": {
*      "httpVersion": "HTTP/1.1",
*      "method": "CONNECT",
*      "url": "https://httpbin.org/connect",
*      "path": "/connect",
*      "port": 443,
*      "headers": {}
*    },
*    "timers": {
*      "dns": 6.751114845275879,
*      "wait": 82.44039916992188,
*      "connect": 12.012739181518555,
*      "ssl": 0.18832600116729736,
*      "receive": 0.6473439931869507,
*      "total": 102.069091796875,
*      "send": 0.0060789999552071095
*    },
*    "err": false,
*    "response": {
*      "status": 200,
*      "statusText": "OK",
*      "payload": "{\n  \"args\": {}, \n  \"url\": \"https://httpbin.org/connect\"\n}\n",
*      "body": {
*        "args": {},
*        "url": "https://httpbin.org/connect"
*      },
*      "mime": "application/json",
*      "contentType": "application/json",
*      "headers": {
*        "Content-Length": "1059",
*        "Content-Type": "application/json",
*      }
*    }
*  }
* ----
**/
fun CONNECT(parts: Array<String>, interpolation: Array<String | Number>) =
  createRequest(parts, interpolation, 'CONNECT')

// BDD VOCABULARY ======================================================================================================

/**
*
* Creates a named test block, used to imply some preparation needed for the subsequents tests.
* This type of block stops the execution if it fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `given` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ]
*    ]
*  ]
* ----
*
**/
fun given(name: String) =
  createNamedBlock("GIVEN", name)

/**
*
* Ignored version of `given` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `xgiven` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      xgiven `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ]
*    ]
*  ]
* ----
*
**/
fun xgiven(name: String) =
  createNamedBlock("GIVEN", name, { skip: true })

/**
*
* Creates a named test block, used to imply some preparation needed for the subsequents tests.
* This type of block stops the execution if it fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | values to be interpolated
* |===
*
* === Example
*
* This example shows how the `given` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* output application/json
* ---
*
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
*  ---
*  describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given (['I have 100 shares of ', ' stock '], [symbol]) in [
*        POST `http://example.org` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 200
*        ]
*      ]
*    ]
*  ]  
* ----
*
**/
fun given(parts: Array<String>, interpolation: Array<String>) =
  given(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `given` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | values to be interpolated
* |===
*
* === Example
*
* This example shows how the `xgiven` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* output application/json
* ---
*
* import * from bat::BDD
*  import * from bat::Assertions
*  var symbol = 'CRM'
*  ---
*  describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      xgiven (['I have 100 shares of ', ' stock '], [symbol]) in [
*        POST `http://example.org` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 200
*        ]
*      ]
*    ]
*  ]
* ----
*
**/
fun xgiven(parts: Array<String>, interpolation: Array<String>) =
  xgiven(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block, used to create side effects.
* This type of block stops the execution if it fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `when` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
*
**/
fun when(name: String) =
  createNamedBlock("WHEN", name, { softFail: false })

/**
*
* Ignored version of `when` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `xwhen` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      xwhen `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
*
**/
fun xwhen(name: String) =
  createNamedBlock("WHEN", name, { skip: true, softFail: false })

/**
*
* Creates a named test block, used to create side effects.
* This type of block stops the execution if it fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts |
* | interpolation |
* |===
*
* === Example
*
* This example shows how the `when` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* var symbol = 'CRM'
* import * from bat::Assertions
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when (['I ask to buy 20 shares of ', 'stock'], [symbol]) in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun when(parts: Array<String>, interpolation: Array<String>) =
  when(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `when` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts |
* | interpolation |
* |===
*
* === Example
*
* This example shows how the `xwhen` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      xwhen (['I ask to buy 20 shares of ', 'stock'], [symbol]) in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xwhen(parts: Array<String>, interpolation: Array<String>) =
  xwhen(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block. Merely for grouping, which you can nest as deep as you want,
* it adds contextual information for reports
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `describe` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun describe(name: String) =
  createNamedBlock("DESCRIBE", name)

/**
*
* Ignored version of `describe` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `xdescribe` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* xdescribe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xdescribe(name: String) =
  createNamedBlock("DESCRIBE", name, { skip: true })

/**
*
* Creates a named test block. Merely for grouping, which you can nest as deep as you want,
* it adds contextual information for reports
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `describe` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var action = 'trades'
* ---
*
* describe (['User', 'stocks'], [action]) in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun describe(parts: Array<String>, interpolation: Array<String>) =
  describe(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `describe` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `xdescribe` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var action = 'trades'
* ---
*
* xdescribe (['User', 'stocks'], [action]) in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xdescribe(parts: Array<String>, interpolation: Array<String>) =
  xdescribe(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block. Same as `describe`
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `scenario` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* scenario `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun scenario(name: String) =
  createNamedBlock("SCENARIO", name)

/**
*
* Ignored version of `xscenario` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `xscenario` behaves under different inputs.
*

* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* scenario `User trades stocks` in [
*    xscenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xscenario(name: String) =
  createNamedBlock("SCENARIO", name, { skip: true })

/**
*
* Creates a named test block. Same as `describe`
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `scenario` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var action = 'trades'
* ---
*
* scenario (['User', 'stocks'], [action]) in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun scenario(parts: Array<String>, interpolation: Array<String>) =
  scenario(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `scenario` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `xscenario` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var action = 'trades'
* ---
*
* xscenario (['User', 'stocks'], [action]) in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xscenario(parts: Array<String>, interpolation: Array<String>) =
  xscenario(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block. This test block is meant to contain all the validations.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `it` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun it(name: String) =
  createNamedBlock("IT", name)

/**
*
* Ignored version of `it` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `xit` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      xit should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xit(name: String) =
  createNamedBlock("IT", name, { skip: true })

/**
*
* Creates a named test block. This test block is meant to contain all the validations.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `it` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should (['have 120 shares of', 'stock'], [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun it(parts: Array<String>, interpolation: Array<String>) =
  it(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `it` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `xit` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* describe `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      xit should (['have 120 shares of', 'stock'], [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xit(parts: Array<String>, interpolation: Array<String>) =
  xit(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block. Same as `describe`
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `suite` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun suite(name: String) =
  createNamedBlock("SUITE", name)

/**
*
* Ignored version of `suite` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | name | Name of the block
* |===
*
* === Example
*
* This example shows how the `xsuite` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xsuite(name: String) =
  createNamedBlock("SUITE", name, { skip: true })

/**
*
* Creates a named test block. Same as `describe`
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `suite` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var action = 'trades'
* ---
*
* suite (['User', 'stocks'], [action]) in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should (have 120 shares of CRM stock) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun suite(parts: Array<String>, interpolation: Array<String>) =
  suite(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `suite` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `xsuite` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var action = 'trades'
* ---
*
* xsuite (['User', 'stocks'], [action]) in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should (have 120 shares of CRM stock) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xsuite(parts: Array<String>, interpolation: Array<String>) =
  xsuite(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block. Meant to be used after a `it` block, to add readability to tests.
* This block doesn't stops the executions if an assertion fails.
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | a | A function that returns a BATTest, typically a `it` block
* | b | Name of the block
* |===
*
* === Example
*
* This example shows how the `should` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun should<T>(a: (T) -> BATTest, b: T): BATTest = (a(b) mergeWith { prefix: "SHOULD", softFail: true }) as BATTest

/**
*
* Creates a named test block. "Standalone" version of the `should` function.
* This block doesn't stops the executions if an assertion fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | str | Name of the block
* |===
*
* === Example
*
* This example shows how the `should` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      should("have 120 shares of CRM stock") in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun should(str: String): BATTest = createNamedBlock("SHOULD", str, { softFail: true })

/**
*
* Ignored version of `should` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | str | Name of the block
* |===
*
* === Example
*
* This example shows how the `xshould` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      xshould("have 120 shares of CRM stock") in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun xshould(str: String): BATTest = createNamedBlock("SHOULD", str, { skip: true, softFail: true })

/**
*
* Creates a named test block. Can be used after an `it` block or standalone.
* This block doesn't stops the executions if an assertion fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `should` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should (['have 120 shares of ', ' stock'] , [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun should(parts: Array<String>, interpolation: Array<String>) = should(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `should` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `xshould` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it xshould (['have 120 shares of ', ' stock'] , [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xshould(parts: Array<String>, interpolation: Array<String>) = xshould(stringInterpolation(parts, interpolation))

/**
*
* Creates a named test block. Same as `should`, but it will stop the execution if an assertion fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | a | A function that returns a BATTest, typically a `it` block
* | b | Name of the block
* |===
*
* === Example
*
* This example shows how the `must` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it must "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun must<T>(a: (T) -> BATTest, b: T): BATTest = (a(b) mergeWith { prefix: "MUST", softFail: false }) as BATTest

/**
*
* Creates a named test block. Same as `should`, but it will stop the execution if an assertion fails.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | str | Name of the block
* |===
*
* === Example
*
* This example shows how the `must` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      must("have 120 shares of CRM stock") in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun must(str: String): BATTest = createNamedBlock("MUST", str, { softFail: false })

/**
*
* Ignored version of `must` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | str | Name of the block
* |===
*
* === Example
*
* This example shows how the `xmust` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      xmust("have 120 shares of CRM stock") in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun xmust(str: String): BATTest = createNamedBlock("MUST", str, { skip: true, softFail: false })

/**
*
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `must` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it must (['have 120 shares of ', ' stock'] , [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun must(parts: Array<String>, interpolation: Array<String>) = must(stringInterpolation(parts, interpolation))

/**
*
* Ignored version of `must` function. This block will be skipped and not executed.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | parts | literal parts of the interpolation
* | interpolation | expressions to be interpolated
* |===
*
* === Example
*
* This example shows how the `xmust` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = 'CRM'
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it xmust (['have 120 shares of ', ' stock'] , [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun xmust(parts: Array<String>, interpolation: Array<String>) = xmust(stringInterpolation(parts, interpolation))

/**
*
* The assuming function skips the test if the given condition is false.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | test | A BATTest. Functions like `it`, `should`, `must`, return a BATTest.
* | condition | The condition that will skip the test if it's `false`.
* |===
*
* === Example
*
* This example shows how the `assuming` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* ---
* describe `E2E Scenario` in [
*   it should 'always do something' in [
*     doSomething()
*   ],
*   it should 'do something else' in [
*     doSomethingElse()
*   ],
*   it should 'sometimes, do something else' assuming (random() > 0.5) in [
*     doSomethingElse()
*   ],
*   it should 'do something in dev environments' assuming (config.env == 'DEV') in [
*     doSomethingElse()
*   ]
*
* ----
*
**/
fun assuming(test: BATTest, condition: Boolean) = do {
  var metadata = test.metadata default {} mergeWith { batAssumingCondition: condition }
  ---
  (test mergeWith { skip: not condition, metadata: metadata }) as BATTest
}

fun withTags(test: BATTest | BATHttpStep, tags: Array<String>) = do {
  var originalMetadata = test.metadata default {}
  var metadata = originalMetadata mergeWith { tags: (originalMetadata.tags default []) ++ tags }
  ---
  (test mergeWith { metadata: metadata }) as BATTest
}

fun withId(test: BATTest | BATHttpStep, id: String) = do {
  var originalMetadata = test.metadata default {}
  var metadata = originalMetadata mergeWith { id: id }
  ---
  (test mergeWith { metadata: metadata }) as BATTest
}

fun withTags(test: BATTest, tag: String) = withTags(test, [tag])

fun withTag(test: BATTest, tag: Array<String>) = withTags(test, tag)

fun withTag(test: BATTest, tag: String) = withTags(test, [tag])

/**
*
* Same as `assuming` function.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | test | A BATTest. Functions like `it`, `should`, `must`, return a BATTest.
* | condition | The condition that will skip the test if it's `false`.
* |===
*
* === Example
*
* This example shows how the `when` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* ---
* describe `E2E Scenario` in [
*   it should 'always do something' in [
*     doSomething()
*   ],
*   it should 'do something else' in [
*     doSomethingElse()
*   ],
*   it should 'sometimes, do something else' when (random() > 0.5) in [
*     doSomethingElse()
*   ],
*   it should 'do something in dev environments' when (config.env == 'DEV') in [
*     doSomethingElse()
*   ]
*
* ----
*
**/
fun when(test: BATTest, condition: Boolean) = assuming(test, condition)

/**
*
* Same as `assuming` function. But negates the condition.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | test | A BATTest. Functions like `it`, `should`, `must`, return a BATTest.
* | condition | The condition that will skip the test if it's `false`.
* |===
*
* === Example
*
* This example shows how the `whenNot` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* ---
* describe `E2E Scenario` in [
*   it should 'always do something' in [
*     doSomething()
*   ],
*   it should 'do something else' in [
*     doSomethingElse()
*   ],
*   it should 'sometimes, do something else' whenNot (random() > 0.5) in [
*     doSomethingElse()
*   ],
*   it should 'do something in dev environments' whenNot (config.env == 'DEV') in [
*     doSomethingElse()
*   ]
*
* ----
*
**/
fun whenNot(test: BATTest, condition: Boolean) = assuming(test, not condition)

/**
*
* Used to execute multiple test blocks. It's meant to be used after another test block like `given`, `suite`, `scenario`,
* `it should`, etc.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | sequence | Test block that will contain  the result of the executions
* | statements | Test blocks to be executed.
* |===
*
* === Example
*
* This example shows how the `in` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun in<T>(sequence: BATTest, statements: Array<() -> T>) =
  describeSequence(sequence, statements)

/**
*
* Blocks the test executions for the given time. Useful when you have to wait for async endpoints to perform some task.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | ms |
* |===
*
* === Example
*
* This example shows how the `sleep` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*	   sleep(1000),
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun sleep(ms: Number) =
  wait(ms)

/**
*
* Same as `sleep`
* Blocks the test executions for the given time. Useful when you have to wait for async endpoints to perform some task.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | ms |
* |===
*
* === Example
*
* This example shows how the `wait` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*	   wait(1000),
*      it should "have 120 shares of CRM stock" in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*  ]
* ]
* ----
**/
fun wait(ms: Number) =
  createNamedBlock("Wait", println("Wait $(ms runtimeWait ms)ms."), { kind: "Wait" })

/**
*
* Creates a test block that will be iterated by the `times` function. Useful to when you have to perform the same operation
* multiple times.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | times |
* |===
*
* === Example
*
* This example shows how the `repeat` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it should "have 120 shares of CRM stock every time" in [
*		repeat(5) times [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*	 ]
*   ]
* ]
* ----
**/
fun repeat(times: Number) =
  createNamedBlock("REPEAT", "Repeat $times times", {
    kind: "LOOPABLE",
    metadata: {
      batLoopable: {
        times: times
      }
    }
  })

/**
*
* Used to execute the loop test block given by the `repeat` function, the amount of times specified.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | sequence |
* | statements |
* |===
*
* === Example
*
* This example shows how the `times` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*	   sleep(1000),
*      it should "have 120 shares of CRM stock every time" in [
*		repeat(5) times [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*	 ]
*   ]
* ]
* ----
**/
fun times<T>(sequence: BATTest, statements: Array<() -> T | Array<T>>) =
  describeSequence(sequence, statements)

/**
*
* The `while` function will continue to execute the `endpointCall` function while the given condition remains `true`.
* You can also specify the max amount of retries and a wait time between executions.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | endpointCall | the function that will be executed while the condition is true. Typically an endpoint call.
* | condition | The condition tha will continue to execute the given function, while it's true.
* | timeBetweenTries | the time to wait between each execution. Default is 1000 (ms)
* | maxRetries | Max times that will execute if the condition never becomes false. Default is 3.
* |===
*
* === Example
*
* This example shows how the `while` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* import * from bat::Types
* ---
*  suite("Example for until and while") in [
*    it should 'test the while prefix' in [
*      while(() -> GET `http://apimon.cloudhub.io/users` with {}, (x: BATHttpStep) -> x.result.response.status != 200, 10000, 5)
*    ],
*    it should 'test the while infix' in [
*      do {
*        () -> GET `http://apimon.cloudhub.io/users` with {} assert [
*            $.response.status mustEqual 200
*          ]
*      } while ($.response.status != 200)
*    ],
*    it should 'test the until prefix' in [
*      until(() -> GET `http://apimon.cloudhub.io/users` with {}, (x: BATHttpStep) -> x.result.response.status != 200, 10000, 5)
*    ],
*    it should 'test the until infix' in [
*      do {
*        () -> GET `http://apimon.cloudhub.io/users` with {} assert [
*            $.response.status mustEqual 200
*          ]
*      } until ($.result.response.status != 200)
*    ]
*  ]
*
* ----
*
**/
fun while<T>(endpointCall: () -> T, condition: (T) -> Boolean, timeBetweenTries: Number = 1000, maxRetries: Number = 3): T = do {
  var result = runtimeWait(endpointCall(), timeBetweenTries)
  ---
  if(condition(result) and maxRetries > 0)
    while(endpointCall, condition, timeBetweenTries, maxRetries - 1)
  else
    result
}

/**
*
* The `until` function will continue to execute the `endpointCall` function until the given condition becomes `false`.
* You can also specify the max amount of retries and a wait time between executions.
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | endpointCall | the function that will be executed while the condition is true. Typically an endpoint call.
* | condition | The condition tha will continue to execute the given function, until it becomes false.
* | timeBetweenTries | the time to wait between each execution. Default is 1000 (ms)
* | maxRetries | Max times that will execute if the condition never becomes false. Default is 3.
* |===
*
* === Example
*
* This example shows how the `until` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* import * from bat::Types
* ---
*  suite("Example for until and while") in [
*    it should 'test the while prefix' in [
*      while(() -> GET `http://apimon.cloudhub.io/users` with {}, (x: BATHttpStep) -> x.result.response.status != 200, 10000, 5)
*    ],
*    it should 'test the while infix' in [
*      do {
*        () -> GET `http://apimon.cloudhub.io/users` with {} assert [
*            $.response.status mustEqual 200
*          ]
*      } while ($.response.status != 200)
*    ],
*    it should 'test the until prefix' in [
*      until(() -> GET `http://apimon.cloudhub.io/users` with {}, (x: BATHttpStep) -> x.result.response.status != 200, 10000, 5)
*    ],
*    it should 'test the until infix' in [
*      do {
*        () -> GET `http://apimon.cloudhub.io/users` with {} assert [
*            $.response.status mustEqual 200
*          ]
*      } until ($.result.response.status != 200)
*    ]
*  ]
*
* ----
**/
fun until<T>(endpointCall: () -> T, condition: (T) -> Boolean, timeBetweenTries: Number = 1000, maxRetries: Number = 3): T = do {
  var result = runtimeWait(endpointCall(), timeBetweenTries)
  ---
  if(condition(result) or maxRetries == 1)
    result
  else
    until(endpointCall, condition, timeBetweenTries, maxRetries - 1)
}
/**
*  Fetches the secret value for the given alias.
*  When running locally it will search for an environment variable with named like the specified `secretAlias` parameter.
*  When running in Api Functional monitoring inside the Anypoint Platform, it will look the secret in Anypoint Secrets Manager,
*  for more information check this documentation page: https://docs.mulesoft.com/api-functional-monitoring/bat-command-reference
*  If the secret isn't found, the null value will returned
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | secretAlias |
* |===
*
* === Example
*
* This example shows how the `secret` behaves under different inputs.
*
* ==== Source
*
* [source,DataWeave,linenums]
* ----
* %dw 2.0
* import * from bat::BDD
* import * from bat::Assertions
* var symbol = secret('symbol') default 'not found'
* ---
*
* suite `User trades stocks` in [
*    scenario `User requests a buy before close of trading` in [
*      given `I have 100 shares of CRM stock` in [
*        POST `http://broker/create_stocks` with {
*          body: {
*            quantity: 100,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      when `I ask to buy 20 shares of CRM stock` in [
*        POST `http://broker/buy_stocks` with {
*          body: {
*            quantity: 20,
*            paper: 'CRM'
*          }
*        } assert [
*          $.response.status == 201
*        ]
*      ],
*      it must (['have 120 shares of ', ' stock'] , [symbol]) in [
*        GET `http://broker/get_stocks/CRM` with {
*          headers: {}
*        } assert [
*          $.response.status == 200,
*          $.response.body.quantity == 120
*        ]
*      ]
*   ]
* ]
* ----
**/
fun secret(secretAlias: String): String | Null = native("csm::ResolveSecret")

