%dw 2.0
output text/plain

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import * from dw::http::Client
import * from bat::Reporters::Common
import getTimeFromHttp from bat::core::Helpers

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"

var packageName = (testIdSplit[0] default '') ++ ':' ++ (testIdSplit[1] default '')

fun state(suite) = do {
  if(suite.skip == true)
    'pending'
  else if(suite.pass == true)
    'passed'
  else
    'failed'
}

fun processHttp(httpCall, suite: String, classname: String = '', keywords: Array<String> = [], id: String | Null = null) = write({
  "job_name": ((if(DEBUG) httpCall.name else dw::System::envVar('JOB_NAME')) default httpCall.name default 'Test name'),
	"configuration": (payload.parameters.config default 'default'),
	"build_number": ((if(DEBUG) 1000 else dw::System::envVar('BUILD_NUMBER')) default payload.metadata.executionNumber default 0),
	"commit": if(DEBUG) 'abcde12' else dw::System::envVar('GIT_COMMIT'),
	"test_type": "api-test",
	"package_name": (packageName default ''),
	"package_version": (testIdSplit[2] default ''),
	"title": (httpCall.name default 'Test name'),
	"suite": suite,
	"path": classname,
	"file": '-',
	"start": getTimeFromHttp(httpCall, payload),
	"duration": (httpCall.time default 0),
	"state": state(httpCall),
	"err": '',
	"keywords": keywords,
	"id": id
}, 'application/json', {indent: false})

fun processSuite(elem) = do {
  flatten(elem.result map print($, elem.name, elem.name))
}

fun processTest(elem, suite: String, classname: String = '', keywords: Array<String> = []) = do {
  var package = elem.name
  var head = if(classname == '') '' else (classname ++ '/')
  var newKeywords = (elem.metadata.tags default []) ++ keywords distinctBy $
  ---
  if (elem.prefix == "SUITE")
    processSuite(elem)
  else
    flatten(elem.result map print($, suite, head ++ sanitizeName(package), newKeywords, elem.metadata.id))
}

fun print(elem, suite: String = payload.name, classname: String = '', keywords: Array<String> = [], id: String | Null = null) =
  elem.kind default "" match {
    case "TEST"  -> processTest(elem, suite, classname, keywords)
    case "HTTP"  -> processHttp(elem, suite, classname, keywords, id)
    case "LOOPABLE" -> processTest(elem, suite, classname, keywords)
    else -> []
  }

fun endpoint(): String = getReporterProperty(options, "SUMO_ENDPOINT")

var dataToSend = flatten(print(payload)) map $ joinBy "\n"
var disabled = isDisabled(options, context)
---
if (DEBUG or endpoint() == '' or disabled)
  dataToSend
else
  (request('POST', endpoint(), {
     body: dataToSend as Binary,
     headers: {
       'Content-Type': 'application/json'
     }
  }) write 'application/json')

