/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.runner.httpCommon;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class HttpProxyProvider {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    private HttpProxyProvider() {
    }

    public static void setProxy(HttpClientBuilder clientBuilder) {
        HttpProxyProvider.setProxy(clientBuilder, HTTP);
        HttpProxyProvider.setProxy(clientBuilder, HTTPS);
    }

    private static void setProxy(HttpClientBuilder clientBuilder, String protocol) {
        String proxyHost = System.getProperty(protocol + ".proxyHost");
        Integer proxyPort = Integer.getInteger(protocol + ".proxyPort");
        if (!HttpProxyProvider.isNullOrEmpty(proxyHost) && proxyPort != null) {
            HttpProxyProvider.setProxyConfiguration(clientBuilder, proxyHost, proxyPort, protocol);
        }
    }

    private static void setProxyConfiguration(HttpClientBuilder clientBuilder, String proxyHost, Integer proxyPort, String protocol) {
        HttpHost proxy = HttpProxyProvider.getHttpHost(proxyHost, proxyPort, protocol);
        clientBuilder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(proxy));
        HttpProxyProvider.setAuthentication(clientBuilder, proxyHost, proxyPort, protocol);
        HttpProxyProvider.setHttpsExtraConfigurations(clientBuilder, protocol);
    }

    private static void setAuthentication(HttpClientBuilder clientBuilder, String proxyHost, Integer proxyPort, String protocol) {
        String proxyUser = System.getProperty(protocol + ".proxyUser");
        String proxyPassword = System.getProperty(protocol + ".proxyPassword");
        if (!HttpProxyProvider.isNullOrEmpty(proxyUser) && !HttpProxyProvider.isNullOrEmpty(proxyPassword)) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
    }

    private static void setHttpsExtraConfigurations(HttpClientBuilder clientBuilder, String protocol) {
        if (protocol.equals(HTTPS)) {
            HttpProxyProvider.setSSLConfiguration(clientBuilder);
        }
    }

    private static void setSSLConfiguration(HttpClientBuilder clientBuilder) {
        SSLContext sslContext;
        try {
            sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
        Registry socketFactoryRegistry = RegistryBuilder.create().register(HTTPS, (Object)factory).register(HTTP, (Object)factory).build();
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connManager);
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private static HttpHost getHttpHost(String proxyHost, int proxyPort, String protocol) {
        return new HttpHost(proxyHost, proxyPort, protocol);
    }
}

