output application/json
import * from bat::Types
import getTimeFromHttp from bat::core::Helpers

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"


fun processHttp(httpCall, suite: String, scenario: String) = {
// TODO: Validate null optional fields
  time: getTimeFromHttp(httpCall, payload),
  name: httpCall.name default 'Test name',
  executionId: payload.metadata.executionId default '',
  executionNumber: (payload.metadata.executionNumber default 0) as Number,
  groupId: testIdSplit[0] default '',
  assetId: testIdSplit[1] default '',
  version: testIdSplit[2] default '',
  targetId: payload.metadata.targetId default '',
  organizationId: payload.metadata.organizationId default '',
  configuration: payload.metadata.configuration default 'default',
  url: httpCall.result.request.url default '',
  path: httpCall.result.request.path default '',
  method: httpCall.result.request.method,
  status: httpCall.result.response.status,
  filepath: '-',
  suite: suite default 'Suite',
  scenario: scenario default 'Scenario',
  pass: httpCall.pass,
  timers: ensureTimers(httpCall.result.timers)
}

// TODO: Missing values must not be sent
fun ensureTimers(timers) = {
  blocked: timers.blocked default 0,
  dns: timers.dns default 0,
  connect: timers.connect default 0,
  send: timers.send default 0,
  waitTime: timers.wait default 0,
  receive: timers.receive default 0,
  ssl: timers.ssl default 0,
  total: timers.total default 0
}

fun processSuite(elem) = do {
  flatten(elem.result map print($, elem.name, elem.name))
}

fun processTest(elem, suite: String, classname: String = '') = do {
  var package = elem.name default 'elemName'
  var head = if(classname == '') '' else (classname ++ ' ❯ ')
  ---
  if(elem.prefix == "SUITE")
    processSuite(elem)
  else
    flatten(elem.result map print($, suite, head ++ package))
}

fun print(elem, suite: String = payload.name, classname: String = '') =
      elem.kind default "" match {
        case "TEST"  -> processTest(elem, suite, classname)
        case "HTTP"  -> processHttp(elem, suite, classname)
        case "LOOPABLE" -> processTest(elem, suite, classname)
        else -> []
      }
---
flatten(print(payload))



