/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.utils;

import org.mule.weave.v2.sdk.NameIdentifierHelper$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class StringEscapeHelper$ {
    public static StringEscapeHelper$ MODULE$;

    static {
        new StringEscapeHelper$();
    }

    public String unescapeString(String str, char quotedBy) {
        Iterator charIterator = new StringOps(Predef$.MODULE$.augmentString(str)).iterator();
        StringBuilder result = new StringBuilder();
        while (charIterator.hasNext()) {
            StringBuilder stringBuilder;
            char next = BoxesRunTime.unboxToChar((Object)charIterator.next());
            if (next == '\\' && charIterator.hasNext()) {
                char controlChar = BoxesRunTime.unboxToChar((Object)charIterator.next());
                if (controlChar == quotedBy) {
                    stringBuilder = result.append(controlChar);
                    continue;
                }
                char c = controlChar;
                switch (c) {
                    case '/': 
                    case '\\': {
                        stringBuilder = result.append(controlChar);
                        break;
                    }
                    case 'n': {
                        stringBuilder = result.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuilder = result.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder = result.append('\f');
                        break;
                    }
                    case 'r': {
                        stringBuilder = result.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder = result.append('\t');
                        break;
                    }
                    case '$': {
                        stringBuilder = result.append('$');
                        break;
                    }
                    case 'u': {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < 4; ++i) {
                            Object object = charIterator.hasNext() ? sb.append(BoxesRunTime.unboxToChar((Object)charIterator.next())) : BoxedUnit.UNIT;
                        }
                        int codePoint = Integer.parseInt(sb.mkString(), 16);
                        String str1 = Character.toString((char)codePoint);
                        stringBuilder = result.append(str1);
                        break;
                    }
                    default: {
                        stringBuilder = result.append(next).append(controlChar);
                        break;
                    }
                }
                continue;
            }
            stringBuilder = result.append(next);
        }
        return result.toString();
    }

    public char unescapeString$default$2() {
        return '\"';
    }

    public String escapeString(String strValue) {
        StringBuilder result = new StringBuilder();
        int len = strValue.length();
        result.append("\"");
        block10: for (int i = 0; i < len; ++i) {
            char c = strValue.charAt(i);
            switch (c) {
                case '\"': {
                    StringBuilder stringBuilder = result.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    StringBuilder stringBuilder;
                    if (len >= i + 6 && strValue.substring(i + 1, i + 6).matches("u[0-9a-fA-F]{4}")) {
                        stringBuilder = result.append("\\");
                        continue block10;
                    }
                    stringBuilder = result.append("\\\\");
                    continue block10;
                }
                case '$': {
                    StringBuilder stringBuilder = result.append("\\$");
                    continue block10;
                }
                case '\b': {
                    StringBuilder stringBuilder = result.append("\\b");
                    continue block10;
                }
                case '\f': {
                    StringBuilder stringBuilder = result.append("\\f");
                    continue block10;
                }
                case '\n': {
                    StringBuilder stringBuilder = result.append("\\n");
                    continue block10;
                }
                case '\r': {
                    StringBuilder stringBuilder = result.append("\\r");
                    continue block10;
                }
                case '\t': {
                    StringBuilder stringBuilder = result.append("\\t");
                    continue block10;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (this.isNonPrintableCharacter(c)) {
                        stringBuilder = result.append(new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                        continue block10;
                    }
                    stringBuilder = result.append(c);
                    continue block10;
                }
            }
        }
        result.append("\"");
        return result.mkString();
    }

    private boolean isNonPrintableCharacter(char c) {
        return c == '\u00ad' || c >= '\u0000' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\u0600' && c <= '\u0604' || c == '\u070f' || c == '\u17b4' || c == '\u17b5' || c >= '\u200c' && c <= '\u200f' || c >= '\u2060' && c <= '\u206f' || c == '\ufeff' || c >= '\ufff0' && c <= '\uffff';
    }

    public boolean keyRequiresQuotes(String key) {
        return !NameIdentifierHelper$.MODULE$.isValidIdentifier(key);
    }

    private StringEscapeHelper$() {
        MODULE$ = this;
    }
}

