/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.lib.G;
import org.apache.jena.shacl.lib.GN;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathFactory;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;

public class ClosedConstraint
implements Constraint {
    private final Set<Node> expected;
    private final Set<Node> ignoredProperties;
    private final boolean active;

    public ClosedConstraint(Graph shapeGraph, Node shapeNode, boolean active) {
        this.expected = this.shapeProperties(shapeGraph, shapeNode);
        this.active = active;
        List<Node> ignored = ClosedConstraint.ignoredProperties(shapeGraph, shapeNode);
        this.ignoredProperties = ignored == null ? Collections.emptySet() : new HashSet<Node>(ignored);
    }

    private static List<Node> ignoredProperties(Graph shapesGraph, Node shNode) {
        Node ignored;
        List ignoredProperties = null;
        if (G.contains(shapesGraph, shNode, SHACL.ignoredProperties, null) && (ignored = G.getOneSP(shapesGraph, shNode, SHACL.ignoredProperties)) != null) {
            ignoredProperties = GraphList.members((GNode)GN.create(shapesGraph, ignored));
            ignoredProperties.forEach(p -> {
                if (!p.isURI()) {
                    throw new ShaclParseException("Only URIs allowed in sh:ignoredProperties at " + ShLib.displayStr(shNode));
                }
            });
        }
        return ignoredProperties;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        this.validate(vCxt, data, shape, focusNode);
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        this.validate(vCxt, data, shape, focusNode);
    }

    private void validate(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        if (!this.active) {
            return;
        }
        Set<Node> actual = this.properties(data, focusNode);
        for (Node p : actual) {
            if (this.expected.contains(p) || this.ignoredProperties.contains(p)) continue;
            Path path = PathFactory.pathLink((Node)p);
            G.listSP(data, focusNode, p).forEach(o -> {
                String msg = this.toString() + " Property = " + ShLib.displayStr(p) + " : Object = " + ShLib.displayStr(o);
                vCxt.reportEntry(msg, shape, focusNode, path, (Node)o, this);
            });
        }
    }

    private Set<Node> properties(Graph data, Node focusNode) {
        return G.find(data, focusNode, Node.ANY, Node.ANY).mapWith(Triple::getPredicate).filterKeep(p -> p.isURI()).toSet();
    }

    private Set<Node> shapeProperties(Graph shapeGraph, Node shapeNode) {
        List<Node> propertyShapes = G.listSP(shapeGraph, shapeNode, SHACL.property);
        HashSet<Node> properties = new HashSet<Node>();
        propertyShapes.forEach(ps -> shapeGraph.find(ps, SHACL.path, null).mapWith(Triple::getObject).filterKeep(Node::isURI).forEachRemaining(properties::add));
        return properties;
    }

    @Override
    public Node getComponent() {
        return SHACL.ClosedConstraintComponent;
    }

    public String toString() {
        String x = "Closed" + this.expected;
        if (!this.ignoredProperties.isEmpty()) {
            x = x + this.ignoredProperties;
        }
        return x;
    }
}

