/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.NsBinder;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.util.EmptyIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

final class OutputElement {
    static final byte BYTE_LT = 60;
    static final byte BYTE_GT = 62;
    static final byte BYTE_SLASH = 47;
    OutputElement _parent;
    WName _name;
    String _uri;
    String _defaultNsURI = "";
    NsBinder _nsBinder = null;

    private OutputElement() {
        this._parent = null;
        this._name = null;
        this._uri = null;
        this._nsBinder = null;
        this._defaultNsURI = "";
    }

    private OutputElement(OutputElement parent, WName name, String uri, NsBinder binder) {
        this._parent = parent;
        this._name = name;
        this._uri = uri;
        this._nsBinder = binder;
        this._defaultNsURI = parent._defaultNsURI;
    }

    protected static OutputElement createRoot() {
        return new OutputElement();
    }

    protected OutputElement createChild(WName name) {
        return new OutputElement(this, name, this._defaultNsURI, this._nsBinder);
    }

    protected OutputElement createChild(WName name, String uri) {
        return new OutputElement(this, name, uri, this._nsBinder);
    }

    protected OutputElement reuseAsChild(OutputElement parent, WName name) {
        OutputElement poolHead = this._parent;
        this.relink(parent, name, this._defaultNsURI);
        return poolHead;
    }

    protected OutputElement reuseAsChild(OutputElement parent, WName name, String nsURI) {
        OutputElement poolHead = this._parent;
        this.relink(parent, name, nsURI);
        return poolHead;
    }

    public void relink(OutputElement parent) {
        this._parent = parent;
        this._nsBinder = parent._nsBinder;
        this._defaultNsURI = parent._defaultNsURI;
    }

    private void relink(OutputElement parent, WName name, String uri) {
        this._parent = parent;
        this._name = name;
        this._uri = uri;
        this._nsBinder = parent._nsBinder;
        this._defaultNsURI = parent._defaultNsURI;
    }

    protected void addToPool(OutputElement poolHead) {
        this._parent = poolHead;
    }

    public OutputElement getParent() {
        return this._parent;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    public WName getName() {
        return this._name;
    }

    public String getLocalName() {
        return this._name.getLocalName();
    }

    public String getNonNullPrefix() {
        String p = this._name.getPrefix();
        return p == null ? "" : null;
    }

    public boolean hasPrefix() {
        return this._name.hasPrefix();
    }

    public String getNameDesc() {
        return this._name.toString();
    }

    public String getNamespaceURI() {
        return this._uri;
    }

    public String getNonNullNamespaceURI() {
        return this._uri == null ? "" : this._uri;
    }

    public String getDefaultNsURI() {
        return this._defaultNsURI;
    }

    public boolean hasEmptyDefaultNs() {
        return this._defaultNsURI == null || this._defaultNsURI.length() == 0;
    }

    public QName getQName() {
        return new QName(this._uri, this._name.getLocalName(), this._name.getPrefix());
    }

    public void setDefaultNsURI(String uri) {
        this._defaultNsURI = uri;
    }

    public String generatePrefix(NamespaceContext rootNsContext, String prefixBase, int[] seqArr) {
        if (this._nsBinder == null) {
            this._nsBinder = NsBinder.createEmpty();
        }
        return this._nsBinder.generatePrefix(prefixBase, rootNsContext, seqArr);
    }

    public void addPrefix(String prefix, String uri) {
        if (this._nsBinder == null) {
            this._nsBinder = NsBinder.createEmpty();
        } else if (this._parent != null && this._parent._nsBinder == this._nsBinder) {
            this._nsBinder = this._nsBinder.createChild();
        }
        this._nsBinder.addMapping(prefix, uri);
    }

    public String getNamespaceURI(String prefix) {
        String uri;
        if (prefix.length() == 0) {
            return this._defaultNsURI;
        }
        if (this._nsBinder != null && (uri = this._nsBinder.findUriByPrefix(prefix)) != null) {
            return uri;
        }
        return null;
    }

    public String getPrefix(String uri) {
        String prefix;
        if (this._defaultNsURI.equals(uri)) {
            return "";
        }
        if (this._nsBinder != null && (prefix = this._nsBinder.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        return null;
    }

    public Iterator<String> getPrefixes(String uri, NamespaceContext rootNsContext) {
        List<String> l = null;
        if (this._defaultNsURI.equals(uri)) {
            l = new ArrayList<String>();
            l.add("");
        }
        if (this._nsBinder != null) {
            l = this._nsBinder.getPrefixesBoundToUri(uri, l);
        }
        if (rootNsContext != null) {
            Iterator<String> it = rootNsContext.getPrefixes(uri);
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefix.length() == 0) continue;
                if (l == null) {
                    l = new ArrayList();
                } else if (l.contains(prefix)) continue;
                l.add(prefix);
            }
        }
        if (l == null) {
            return EmptyIterator.getInstance();
        }
        return l.iterator();
    }

    public String getExplicitPrefix(String uri, NamespaceContext rootNsContext) {
        String prefix;
        if (this._nsBinder != null && (prefix = this._nsBinder.findPrefixByUri(uri)) != null) {
            return prefix;
        }
        if (rootNsContext != null && (prefix = rootNsContext.getPrefix(uri)) != null && prefix.length() > 0) {
            return prefix;
        }
        return null;
    }

    public PrefixState checkPrefixValidity(String prefix, String nsURI, NamespaceContext rootNsContext) {
        String act;
        if (prefix.equals("xml")) {
            return nsURI.equals("http://www.w3.org/XML/1998/namespace") ? PrefixState.OK : PrefixState.MISBOUND;
        }
        String string = act = this._nsBinder == null ? null : this._nsBinder.findUriByPrefix(prefix);
        if (act == null && rootNsContext != null) {
            act = rootNsContext.getNamespaceURI(prefix);
        }
        if (act == null) {
            return PrefixState.UNBOUND;
        }
        return act == nsURI || act.equals(nsURI) ? PrefixState.OK : PrefixState.MISBOUND;
    }

    public boolean isPrefixBoundTo(String prefix, String nsURI, NamespaceContext rootNsContext) {
        String act;
        if (prefix == null || prefix.length() == 0) {
            return this._defaultNsURI.equals(nsURI);
        }
        if ("xml".equals(prefix)) {
            return nsURI.equals("http://www.w3.org/XML/1998/namespace");
        }
        String string = act = this._nsBinder == null ? null : this._nsBinder.findUriByPrefix(prefix);
        if (act == null && rootNsContext != null) {
            act = rootNsContext.getNamespaceURI(prefix);
        }
        return act != null && (act == nsURI || act.equals(nsURI));
    }

    public boolean isPrefixUnbound(String prefix, NamespaceContext rootNsContext) {
        String act;
        String string = act = this._nsBinder == null ? null : this._nsBinder.findUriByPrefix(prefix);
        if (act != null && act.length() != 0) {
            return false;
        }
        if (prefix.equals("xml")) {
            return false;
        }
        return rootNsContext == null || (act = rootNsContext.getNamespaceURI(prefix)) == null || act.length() == 0;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public static enum PrefixState {
        UNBOUND,
        OK,
        MISBOUND;

    }
}

