/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import java.util.ArrayList;

public class CanonicalPathUtils {
    private static final boolean DONT_CANONICALIZE_BACKSLASH = Boolean.parseBoolean("io.undertow.DONT_CANONICALIZE_BACKSLASH");
    static final int START = -1;
    static final int NORMAL = 0;
    static final int FIRST_SLASH = 1;
    static final int ONE_DOT = 2;
    static final int TWO_DOT = 3;
    static final int FIRST_BACKSLASH = 4;

    public static String canonicalize(String path) {
        int state = -1;
        block5: for (int i = path.length() - 1; i >= 0; --i) {
            char c = path.charAt(i);
            switch (c) {
                case '/': {
                    if (state == 1) {
                        return CanonicalPathUtils.realCanonicalize(path, i + 1, 1);
                    }
                    if (state == 2) {
                        return CanonicalPathUtils.realCanonicalize(path, i + 2, 1);
                    }
                    if (state == 3) {
                        return CanonicalPathUtils.realCanonicalize(path, i + 3, 1);
                    }
                    state = 1;
                    continue block5;
                }
                case '.': {
                    if (state == 1 || state == -1 || state == 4) {
                        state = 2;
                        continue block5;
                    }
                    if (state == 2) {
                        state = 3;
                        continue block5;
                    }
                    state = 0;
                    continue block5;
                }
                case '\\': {
                    if (!DONT_CANONICALIZE_BACKSLASH) {
                        if (state == 4) {
                            return CanonicalPathUtils.realCanonicalize(path, i + 1, 4);
                        }
                        if (state == 2) {
                            return CanonicalPathUtils.realCanonicalize(path, i + 2, 4);
                        }
                        if (state == 3) {
                            return CanonicalPathUtils.realCanonicalize(path, i + 3, 4);
                        }
                        state = 4;
                        continue block5;
                    }
                }
                default: {
                    state = 0;
                }
            }
        }
        return path;
    }

    private static String realCanonicalize(String path, int lastDot, int initialState) {
        int state = initialState;
        int eatCount = 0;
        int tokenEnd = path.length();
        ArrayList<String> parts = new ArrayList<String>();
        block7: for (int i = lastDot - 1; i >= 0; --i) {
            char c = path.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '/') {
                        state = 1;
                        if (eatCount <= 0) continue block7;
                        --eatCount;
                        tokenEnd = i;
                        continue block7;
                    }
                    if (c != '\\' || DONT_CANONICALIZE_BACKSLASH) continue block7;
                    state = 4;
                    if (eatCount <= 0) continue block7;
                    --eatCount;
                    tokenEnd = i;
                    continue block7;
                }
                case 1: {
                    if (c == '.') {
                        state = 2;
                        continue block7;
                    }
                    if (c == '/') {
                        if (eatCount > 0) {
                            --eatCount;
                            tokenEnd = i;
                            continue block7;
                        }
                        parts.add(path.substring(i + 1, tokenEnd));
                        tokenEnd = i;
                        continue block7;
                    }
                    state = 0;
                    continue block7;
                }
                case 4: {
                    if (c == '.') {
                        state = 2;
                        continue block7;
                    }
                    if (c == '\\') {
                        if (eatCount > 0) {
                            --eatCount;
                            tokenEnd = i;
                            continue block7;
                        }
                        parts.add(path.substring(i + 1, tokenEnd));
                        tokenEnd = i;
                        continue block7;
                    }
                    state = 0;
                    continue block7;
                }
                case 2: {
                    if (c == '.') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '/' || c == '\\' && !DONT_CANONICALIZE_BACKSLASH) {
                        if (i + 2 != tokenEnd) {
                            parts.add(path.substring(i + 2, tokenEnd));
                        }
                        tokenEnd = i;
                        state = c == '/' ? 1 : 4;
                        continue block7;
                    }
                    state = 0;
                    continue block7;
                }
                case 3: {
                    if (c == '/' || c == '\\' && !DONT_CANONICALIZE_BACKSLASH) {
                        if (i + 3 != tokenEnd) {
                            parts.add(path.substring(i + 3, tokenEnd));
                        }
                        tokenEnd = i;
                        ++eatCount;
                        state = c == '/' ? 1 : 4;
                        continue block7;
                    }
                    state = 0;
                }
            }
        }
        StringBuilder result = new StringBuilder();
        if (tokenEnd != 0) {
            result.append(path.substring(0, tokenEnd));
        }
        for (int i = parts.size() - 1; i >= 0; --i) {
            result.append((String)parts.get(i));
        }
        if (result.length() == 0) {
            return "/";
        }
        return result.toString();
    }

    private CanonicalPathUtils() {
    }
}

