/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Protocols;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import org.mule.weave.v2.module.http.service.HttpServerRequest;
import org.mule.weave.v2.module.http.service.HttpServerResponse;
import org.mule.weave.v2.module.http.undertow.InputStreamSender;
import org.mule.weave.v2.module.http.undertow.InputStreamSender$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0002\u0004\u0001+!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u00038\u0001\u0011\u0005\u0001\bC\u0003=\u0001\u0011\u0005S\bC\u0003G\u0001\u0011%qIA\u000bV]\u0012,'\u000f^8x'\u0016\u0014h/\u001a:IC:$G.\u001a:\u000b\u0005\u001dA\u0011\u0001C;oI\u0016\u0014Ho\\<\u000b\u0005%Q\u0011\u0001\u00025uiBT!a\u0003\u0007\u0002\r5|G-\u001e7f\u0015\tia\"\u0001\u0002we)\u0011q\u0002E\u0001\u0006o\u0016\fg/\u001a\u0006\u0003#I\tA!\\;mK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-y\u0001\"a\u0006\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\t1\fgn\u001a\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0004PE*,7\r\u001e\t\u0003?\u0015j\u0011\u0001\t\u0006\u0003C\t\naa]3sm\u0016\u0014(BA\u0004$\u0015\u0005!\u0013AA5p\u0013\t1\u0003EA\u0006IiR\u0004\b*\u00198eY\u0016\u0014\u0018\u0001C2bY2\u0014\u0017mY6\u0011\t%bc\u0006N\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\tIa)\u001e8di&|g.\r\t\u0003_Ij\u0011\u0001\r\u0006\u0003c!\tqa]3sm&\u001cW-\u0003\u00024a\t\t\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKF,Xm\u001d;\u0011\u0005=*\u0014B\u0001\u001c1\u0005IAE\u000f\u001e9TKJ4XM\u001d*fgB|gn]3\u0002\rqJg.\u001b;?)\tI4\b\u0005\u0002;\u00015\ta\u0001C\u0003(\u0005\u0001\u0007\u0001&A\u0007iC:$G.\u001a*fcV,7\u000f\u001e\u000b\u0003}\u0005\u0003\"!K \n\u0005\u0001S#\u0001B+oSRDQAQ\u0002A\u0002\r\u000b\u0001\"\u001a=dQ\u0006tw-\u001a\t\u0003?\u0011K!!\u0012\u0011\u0003%!#H\u000f]*feZ,'/\u0012=dQ\u0006tw-Z\u0001\rEVLG\u000e\u001a*fcV,7\u000f\u001e\u000b\u0003]!CQA\u0011\u0003A\u0002\r\u0003")
public class UndertowServerHandler
implements HttpHandler {
    private final Function1<HttpServerRequest, HttpServerResponse> callback;

    public void handleRequest(HttpServerExchange exchange) {
        block5: {
            if (exchange.isInIoThread()) {
                HeaderValues upgrade = exchange.getRequestHeaders().get(Headers.UPGRADE);
                Object object = upgrade != null && upgrade.contains((Object)"h2c") ? exchange.setProtocol(Protocols.HTTP_1_1) : BoxedUnit.UNIT;
                exchange.dispatch((HttpHandler)this);
            } else {
                exchange.startBlocking();
                HttpServerRequest request = this.buildRequest(exchange);
                try {
                    HttpServerResponse response = (HttpServerResponse)this.callback.apply((Object)request);
                    exchange.setStatusCode(response.statusCode());
                    response.headers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        HeaderMap headerMap = exchange.getResponseHeaders().add(new HttpString(key), value);
                        return headerMap;
                    });
                    if (response.body() != null) {
                        new InputStreamSender(response.body(), exchange, response.closeCallBack(), InputStreamSender$.MODULE$.$lessinit$greater$default$4(), InputStreamSender$.MODULE$.$lessinit$greater$default$5(), InputStreamSender$.MODULE$.$lessinit$greater$default$6(), InputStreamSender$.MODULE$.$lessinit$greater$default$7()).send();
                        break block5;
                    }
                    exchange.endExchange();
                }
                catch (Error e) {
                    System.err.println("[ERROR] Unexpected error occurred.");
                    e.printStackTrace();
                    exchange.endExchange();
                }
            }
        }
    }

    private HttpServerRequest buildRequest(HttpServerExchange exchange) {
        InputStream body = exchange.getInputStream();
        HeaderMap requestMultiMap = exchange.getRequestHeaders();
        ArrayBuffer headers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        requestMultiMap.forEach(headerValue -> {
            HttpString headerName = headerValue.getHeaderName();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headerValue.toArray())).foreach((Function1 & Serializable & scala.Serializable)value -> headers.$plus$eq((Object)new Tuple2((Object)headerName.toString(), value)));
        });
        Map queryParametersMultiMap = exchange.getQueryParameters();
        ArrayBuffer queryParams = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryParametersMultiMap.forEach((name, queue) -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(queue.toArray())).foreach((Function1 & Serializable & scala.Serializable)value -> queryParams.$plus$eq((Object)new Tuple2(name, (Object)value.toString()))));
        String relativePath = exchange.getRelativePath();
        return new HttpServerRequest(body, relativePath, exchange.getRequestMethod().toString(), (Seq<Tuple2<String, String>>)headers, (Seq<Tuple2<String, String>>)queryParams);
    }

    public UndertowServerHandler(Function1<HttpServerRequest, HttpServerResponse> callback) {
        this.callback = callback;
    }
}

