/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.WriterSSE;
import org.apache.jena.sparql.util.PrintSerializable;

public class QueryOutputUtils {
    public static String toString(PrintSerializable item, PrefixMapping pmap) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        SerializationContext sCxt = new SerializationContext(pmap);
        item.output((IndentedWriter)buff, sCxt);
        return buff.toString();
    }

    public static String toString(PrintSerializable item) {
        return QueryOutputUtils.toString(item, null);
    }

    public static void printPlan(Query query, QueryExecution qe) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(query, qe.getDataset().asDatasetGraph(), ARQ.getContext());
        if (f == null) {
            System.err.println("printPlan: Unknown engine type: " + Lib.className((Object)qe));
        }
        Plan plan = f.create(query, qe.getDataset().asDatasetGraph(), BindingRoot.create(), ARQ.getContext());
        SerializationContext sCxt = new SerializationContext(query);
        IndentedWriter out = IndentedWriter.stdout;
        plan.output(out, sCxt);
        out.flush();
    }

    public static void printQuery(Query query) {
        IndentedWriter out = IndentedWriter.stdout;
        QueryOutputUtils.printQuery(out, query);
    }

    public static void printQuery(IndentedWriter out, Query query) {
        QueryOutputUtils.printQuery(out, query, Syntax.defaultQuerySyntax);
    }

    public static void printQuery(IndentedWriter out, Query query, Syntax syntax) {
        query.serialize(out, syntax);
        out.flush();
    }

    public static void printOp(Query query, boolean optimize) {
        IndentedWriter out = IndentedWriter.stdout;
        QueryOutputUtils.printOp(out, query, optimize);
    }

    public static void printOp(IndentedWriter out, Query query, boolean printOptimized) {
        Op op = Algebra.compile(query);
        if (printOptimized) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out(out, op, (Prologue)query);
        out.flush();
    }

    public static void printQuad(Query query, boolean printOptimized) {
        IndentedWriter out = IndentedWriter.stdout;
        QueryOutputUtils.printQuad(out, query, printOptimized);
    }

    public static void printQuad(IndentedWriter out, Query query, boolean printOptimized) {
        Op op = Algebra.compile(query);
        if (printOptimized) {
            op = Algebra.optimize(op);
        }
        op = Algebra.toQuadForm(op);
        WriterSSE.out(out, op, (Prologue)query);
        out.flush();
    }
}

