import try from dw::Runtime

import * from bat::Types
import printPassCapable, push, pop, println, DEBUG from bat::core::Console

fun transformSetValue<T>(result: bat::Mutable::HashMapSetOperation<T>) =
  {
    kind: "StoreValue",
    pass: true,
    name: "Stored new value for $(result.key)",
    softFail: false,
    result: result
  } as BATAssertion




fun executeStep0<T>(fn: () -> T, name: String = 'Step') =
  using(
    msg = push(name),
    result = safeExecution(fn),
    maybePrint = result match {
      case x is bat::Mutable::HashMapSetOperation<Any> -> printPassCapable(transformSetValue(x))
      case x if x is BATAssertion and (x as Object).kind == "RuntimeException" -> printPassCapable(x)
      else -> result
    },
    msg1 = pop(name)
  )
    maybePrint

fun executeStep1<T, X>(fn: (X) -> T, arg: X, name: String = 'Step') =
  using (
    msg = push(name),
    result = safeExecution(fn, arg),
    msg1 = pop(name)
  ) result

fun safeExecution<T>(fn: () -> T) =
  using (result = try(() -> fn()))
    if (result.success)
      result.result!
    else
      errorToBATAssertion(result)

fun safeExecution<T, X>(fn: (X) -> T, param: X) =
  using (result = try(() -> fn(param)))
    if (result.success)
      result.result!
    else
      errorToBATAssertion(result)

fun runSequence<X>(list: Array<() -> X>) = do {
  list match {
    case [] -> []
    case [head ~ tail] ->
      using(result = executeStep0(head))
      result match {
        case result is BATPassCapable<Any> ->
          // if it is not a softFail, terminate execution, tail will be not processed
          if (result.softFail == false and result.pass == false)
            [result]
          else
            [result ~ runSequence(tail)]
        case result is Array<BATPassCapable<Any>> ->
          result ++ runSequence(tail)
        else -> [
          printPassCapable({
            kind: "TestException",
            name: write(result) as String ++ " is not a valid testing step.",
            pass: false,
            softFail: true,
            result: result,
            skip: false,
            prefix: "Invalid test step"
          } as BATPassCapable<Any>) ~ runSequence(tail)
        ]
      }
  }
}

fun errorToBATAssertion(result: dw::Runtime::TryResult<Any>): BATAssertion =
  using(error = result.error)
    {
      kind: "RuntimeException",
      pass: false,
      name: error.message default error.kind default "",
      softFail: false,
      result: error
    } as BATAssertion
