@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  bat-cli startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and BAT_CLI_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-Djava.net.preferIPv4Stack=true"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\bat-cli-1.1.62.jar;%APP_HOME%\lib\bat-runner-2.0.60.jar;%APP_HOME%\lib\bdd-core-1.24.63.jar;%APP_HOME%\lib\io-module-2.5.2.jar;%APP_HOME%\lib\runtime-2.5.2.jar;%APP_HOME%\lib\java-module-2.5.2.jar;%APP_HOME%\lib\core-modules-2.5.2.jar;%APP_HOME%\lib\yaml-module-2.5.2.jar;%APP_HOME%\lib\core-2.5.2.jar;%APP_HOME%\lib\parser-2.5.2.jar;%APP_HOME%\lib\scala-xml_2.12-2.2.0.jar;%APP_HOME%\lib\jackson-dataformat-yaml-2.16.1.jar;%APP_HOME%\lib\jackson-datatype-jsr310-2.16.1.jar;%APP_HOME%\lib\jackson-databind-2.16.1.jar;%APP_HOME%\lib\jackson-annotations-2.16.1.jar;%APP_HOME%\lib\jackson-core-2.16.1.jar;%APP_HOME%\lib\jackson-module-scala_2.12-2.16.1.jar;%APP_HOME%\lib\scala-reflect-2.12.18.jar;%APP_HOME%\lib\wlang-2.5.2.jar;%APP_HOME%\lib\debugger-2.5.2.jar;%APP_HOME%\lib\parboiled_2.12-2.1.8.jar;%APP_HOME%\lib\syaml_2.12-2.0.334.jar;%APP_HOME%\lib\scaffeine_2.12-4.0.0.jar;%APP_HOME%\lib\shapeless_2.12-2.3.3.jar;%APP_HOME%\lib\scala-common_2.12-2.0.99.jar;%APP_HOME%\lib\scala-java8-compat_2.12-0.9.1.jar;%APP_HOME%\lib\macro-compat_2.12-1.1.1.jar;%APP_HOME%\lib\scala-library-2.12.18.jar;%APP_HOME%\lib\cron-utils-9.2.1.jar;%APP_HOME%\lib\caffeine-2.8.1.jar;%APP_HOME%\lib\undertow-core-2.3.14.Final.jar;%APP_HOME%\lib\woodstox-core-6.4.0.jar;%APP_HOME%\lib\aalto-xml-1.3.2.jar;%APP_HOME%\lib\jakarta.mail-1.6.7.jar;%APP_HOME%\lib\commons-io-2.7.jar;%APP_HOME%\lib\httpmime-4.5.13.jar;%APP_HOME%\lib\httpclient-4.5.13.jar;%APP_HOME%\lib\httpcore-4.4.13.jar;%APP_HOME%\lib\slf4j-api-2.0.7.jar;%APP_HOME%\lib\paranamer-2.8.jar;%APP_HOME%\lib\checker-qual-3.1.0.jar;%APP_HOME%\lib\error_prone_annotations-2.3.4.jar;%APP_HOME%\lib\xnio-nio-3.8.15.Final.jar;%APP_HOME%\lib\xnio-api-3.8.16.Final.jar;%APP_HOME%\lib\wildfly-client-config-1.0.1.Final.jar;%APP_HOME%\lib\jboss-threads-3.5.0.Final.jar;%APP_HOME%\lib\jboss-logging-3.4.3.Final.jar;%APP_HOME%\lib\stax2-api-4.2.1.jar;%APP_HOME%\lib\jakarta.activation-1.2.1.jar;%APP_HOME%\lib\snakeyaml-2.2.jar;%APP_HOME%\lib\commons-logging-1.2.jar;%APP_HOME%\lib\commons-codec-1.15.jar;%APP_HOME%\lib\wildfly-common-1.5.4.Final.jar


@rem Execute bat-cli
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %BAT_CLI_OPTS%  -classpath "%CLASSPATH%" com.mulesoft.bat.EntryPoint %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable BAT_CLI_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%BAT_CLI_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
