/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.io;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Comparator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mule.weave.v2.core.io.DefaultOutputStreamWrapper;
import org.mule.weave.v2.core.io.LimitedOutputStreamWrapper;
import org.mule.weave.v2.core.io.OutputStreamWrapper;
import org.mule.weave.v2.core.io.service.WorkingDirectoryService;
import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.module.reader.FileAutoPersistedOutputStream;
import scala.Array$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class FileHelper$ {
    public static FileHelper$ MODULE$;
    private ExecutorService scheduler;
    private final Logger org$mule$weave$v2$core$io$FileHelper$$logger;
    private final AtomicLong counter;
    private volatile boolean bitmap$0;

    static {
        new FileHelper$();
    }

    public Logger org$mule$weave$v2$core$io$FileHelper$$logger() {
        return this.org$mule$weave$v2$core$io$FileHelper$$logger;
    }

    private AtomicLong counter() {
        return this.counter;
    }

    private ExecutorService scheduler$lzycompute() {
        FileHelper$ fileHelper$ = this;
        synchronized (fileHelper$) {
            if (!this.bitmap$0) {
                this.scheduler = Executors.newFixedThreadPool(10, new ThreadFactory(){
                    private final AtomicLong counter;

                    private AtomicLong counter() {
                        return this.counter;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public Thread newThread(Runnable r) {
                        void var2_2;
                        Thread thread = new Thread(r, new StringBuilder(19).append("Weave_File_Deleter_").append(this.counter().getAndDecrement()).toString());
                        thread.setDaemon(true);
                        return var2_2;
                    }
                    {
                        this.counter = new AtomicLong(1L);
                    }
                });
                this.bitmap$0 = true;
            }
        }
        return this.scheduler;
    }

    private ExecutorService scheduler() {
        return !this.bitmap$0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public File[] ls(File directory) {
        return (File[])Option$.MODULE$.apply((Object)directory.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
    }

    public File tmpDir() {
        return new File(this.tmpFilePath());
    }

    public String tmpFilePath() {
        return System.getProperty("java.io.tmpdir");
    }

    public File createTempFile(String prefix, String suffix) {
        long n = this.counter().getAndIncrement();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        File tmpFile = this.tmpDir();
        if (!tmpFile.exists()) {
            throw new RuntimeException(new StringBuilder(106).append("The specified temporary ").append(tmpFile.getAbsolutePath()).append(" directory does not exits. Please create the directory or provide a different one.").toString());
        }
        File result = new File(tmpFile, new StringBuilder(0).append(prefix).append(n).append(suffix).toString());
        while (result.exists()) {
            n = this.counter().getAndIncrement();
            result = new File(tmpFile, new StringBuilder(0).append(prefix).append(n).append(suffix).toString());
        }
        return result;
    }

    public void deleteAsync(File tmp) {
        this.scheduler().submit(new Runnable(tmp){
            private final File tmp$1;

            public void run() {
                block0: {
                    boolean deleted;
                    if (!this.tmp$1.exists() || (deleted = this.tmp$1.delete()) || !this.tmp$1.exists()) break block0;
                    FileHelper$.MODULE$.org$mule$weave$v2$core$io$FileHelper$$logger().log(Level.WARNING, new StringBuilder(55).append("Unable to async delete ").append(this.tmp$1.getAbsolutePath()).append(", it may be locked someone else.").toString());
                }
            }
            {
                this.tmp$1 = tmp$1;
            }
        });
    }

    public void deleteDirectory(File folder) {
        block0: {
            if (!folder.exists()) break block0;
            Comparator comparator = Comparator.reverseOrder();
            Files.walk(folder.toPath(), new FileVisitOption[0]).sorted(comparator).forEach(f -> Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> f.toFile().delete()));
        }
    }

    public String baseName(File x) {
        String fileName = x.getName();
        return x.isDirectory() ? fileName : this.baseName(fileName);
    }

    public String baseName(String fileName) {
        return fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
    }

    public String getExtension(File output) {
        String name = output.getName();
        return (String)this.getExtension(name).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
    }

    public Option<String> getExtension(String name) {
        return name.lastIndexOf(46) >= 0 ? new Some(new StringOps(Predef$.MODULE$.augmentString(name)).drop(name.lastIndexOf(46))) : None$.MODULE$;
    }

    public File createBufferFile(String name) {
        return this.createTempFile(new StringBuilder(11).append("dw-buffer-").append(name).append("-").toString(), ".tmp");
    }

    public OutputStreamWrapper newOutputStreamWrapper(SettingsService settingsService) {
        long maxSize = settingsService.workingDirectory().maxOutputBufferSize();
        return maxSize > -1L ? new LimitedOutputStreamWrapper(maxSize, settingsService) : new DefaultOutputStreamWrapper();
    }

    public OutputStream wrapOutputStream(OutputStream os, SettingsService settingsService) {
        return this.newOutputStreamWrapper(settingsService).wrap(os);
    }

    public FileAutoPersistedOutputStream newFileOutputStream(String classifier, WorkingDirectoryService fileService, SettingsService settingsService) {
        File bufferFile = fileService.newBufferFile(classifier);
        return new FileAutoPersistedOutputStream(bufferFile, fileService, settingsService);
    }

    private FileHelper$() {
        MODULE$ = this;
        this.org$mule$weave$v2$core$io$FileHelper$$logger = Logger.getLogger(this.getClass().getName());
        this.counter = new AtomicLong(1L);
    }
}

