/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.runner.compiler;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.mulesoft.bat.dw.dao.BATBaseElement;
import com.mulesoft.bat.dw.dao.BATTestResult;
import com.mulesoft.bat.runner.compiler.BatCompiler;
import com.mulesoft.bat.runner.compiler.ContextRunner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.service.WeaveRuntimePrivilege$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0002\u0004\u0001#!A\u0001\u0004\u0001B\u0001B\u0003%\u0011\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003-\u0001\u0011\u0005Q\u0006C\u0003K\u0001\u0011\u00051JA\tCCR,\u00050Z2vi\u0006\u0014G.Z*qK\u000eT!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\rI,hN\\3s\u0015\tYA\"A\u0002cCRT!!\u0004\b\u0002\u00115,H.Z:pMRT\u0011aD\u0001\u0004G>l7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017AB:de&\u0004H\u000f\u0005\u0002\u001bK5\t1D\u0003\u0002\u001d;\u00059!/\u001e8uS6,'B\u0001\u0010 \u0003\t1(G\u0003\u0002!C\u0005)q/Z1wK*\u0011!eI\u0001\u0005[VdWMC\u0001%\u0003\ry'oZ\u0005\u0003Mm\u0011q\u0002R1uC^+\u0017M^3TGJL\u0007\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005%Z\u0003C\u0001\u0016\u0001\u001b\u00051\u0001\"\u0002\r\u0003\u0001\u0004I\u0012AB9v_R,7\u000f\u0006\u0002/sA\u0011qF\u000e\b\u0003aQ\u0002\"!\r\u000b\u000e\u0003IR!a\r\t\u0002\rq\u0012xn\u001c;?\u0013\t)D#\u0001\u0004Qe\u0016$WMZ\u0005\u0003oa\u0012aa\u0015;sS:<'BA\u001b\u0015\u0011\u0015Q4\u00011\u0001<\u0003\u00151\u0018\r\\;fa\ta\u0014\tE\u00020{}J!A\u0010\u001d\u0003\u000b\rc\u0017m]:\u0011\u0005\u0001\u000bE\u0002\u0001\u0003\n\u0005f\n\t\u0011!A\u0003\u0002\r\u00131a\u0018\u00132#\t!u\t\u0005\u0002\u0014\u000b&\u0011a\t\u0006\u0002\b\u001d>$\b.\u001b8h!\t\u0019\u0002*\u0003\u0002J)\t\u0019\u0011I\\=\u0002\u000f\u0015DXmY;uKR)AJ\u00196mcR\u0019Q*W/1\u00059;\u0006cA(U-6\t\u0001K\u0003\u0002R%\u0006\u0019A-Y8\u000b\u0005MS\u0011A\u00013x\u0013\t)\u0006K\u0001\bC\u0003R\u0013\u0015m]3FY\u0016lWM\u001c;\u0011\u0005\u0001;F!\u0003-\u0005\u0003\u0003\u0005\tQ!\u0001D\u0005\ryFE\r\u0005\u0006\u000f\u0011\u0001\u001dA\u0017\t\u0003UmK!\u0001\u0018\u0004\u0003\u0017\t\u000bGoQ8na&dWM\u001d\u0005\u0006=\u0012\u0001\u001daX\u0001\u000eG>tG/\u001a=u%Vtg.\u001a:\u0011\u0005)\u0002\u0017BA1\u0007\u00055\u0019uN\u001c;fqR\u0014VO\u001c8fe\")1\r\u0002a\u0001I\u0006q1/\u001a:wS\u000e,W*\u00198bO\u0016\u0014\bCA3i\u001b\u00051'BA4\u001e\u0003\u0015iw\u000eZ3m\u0013\tIgM\u0001\bTKJ4\u0018nY3NC:\fw-\u001a:\t\u000b-$\u0001\u0019\u0001\u0018\u0002\u001d\r|gNZ5h\r&dWMT1nK\")Q\u000e\u0002a\u0001]\u0006Qq/Z1wK\u0012+'-^4\u0011\u0005My\u0017B\u00019\u0015\u0005\u001d\u0011un\u001c7fC:DQA\u001d\u0003A\u0002M\f\u0001#\u001a=fGV$\u0018n\u001c8US6,w.\u001e;\u0011\u0005M!\u0018BA;\u0015\u0005\u0011auN\\4")
public class BatExecutableSpec {
    private final DataWeaveScript script;

    public String quotes(Class<?> value) {
        return new StringBuilder(2).append("\"").append(value.getName()).append("\"").toString();
    }

    public BATBaseElement<?> execute(ServiceManager serviceManager, String configFileName, boolean weaveDebug, long executionTimeout, BatCompiler compiler, ContextRunner contextRunner) {
        return (BATBaseElement)contextRunner.execute((Function0 & Serializable & scala.Serializable)() -> {
            Object contentResult;
            Object object;
            ScriptingBindings bindings = new ScriptingBindings();
            bindings.addBinding("config", compiler.readConfiguration(serviceManager, configFileName, contextRunner));
            DataWeaveScript dataWeaveScript = weaveDebug ? $this.script.enableDebug() : $this.script.disableDebug();
            serviceManager.loggingService().logInfo(new StringBuilder(36).append("*** Setting script timeout (").append(executionTimeout).append(" ms) ***").toString());
            boolean javaLoadClass = serviceManager.securityManager().supports(WeaveRuntimePrivilege$.MODULE$.JAVA_LOAD_CLASS(), (Value[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Value.class)));
            boolean javaReflection = serviceManager.securityManager().supports(WeaveRuntimePrivilege$.MODULE$.JAVA_REFLECTION(), (Value[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Value.class)));
            $this.script.maxTime(executionTimeout);
            if (javaLoadClass && javaReflection) {
                DataWeaveResult dataWeaveResult = $this.script.write(bindings, serviceManager, "application/java");
                object = dataWeaveResult.getContent();
            } else {
                ExecuteResult result = $this.script.exec(bindings, serviceManager);
                String allowList = ((TraversableOnce)((TraversableLike)new .colon.colon(BATBaseElement.class, (List)new .colon.colon(BATTestResult.class, (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$1 -> this.quotes((Class<?>)x$1), Seq$.MODULE$.canBuildFrom())).mkString(",");
                ScriptingBindings metadataFilterBindings = new ScriptingBindings();
                metadataFilterBindings.addBinding("payload", result.getResultMaterialized());
                DataWeaveScript metadataFilterScript = compiler.scriptingEngine().compile(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(186).append("\n               |input payload application/dw\n               |output application/java\n               |---\n               |bat::core::Helpers::filterMetadata(payload, [").append(allowList).append("])\n               |").toString())).stripMargin());
                object = metadataFilterScript.write(metadataFilterBindings).getContent();
            }
            Object object2 = contentResult = object;
            if (object2 instanceof BATBaseElement) {
                BATBaseElement bATBaseElement = (BATBaseElement)object2;
                return bATBaseElement;
            }
            if (object2 instanceof LinkedHashMap) {
                BATTestResult bATTestResult;
                LinkedHashMap linkedHashMap = (LinkedHashMap)object2;
                try {
                    BATTestResult batBaseElement;
                    ObjectMapper objectMapper = new ObjectMapper();
                    objectMapper.registerModule((Module)new JavaTimeModule());
                    objectMapper.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
                    objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
                    objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                    objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    bATTestResult = batBaseElement = (BATTestResult)objectMapper.convertValue((Object)linkedHashMap, BATTestResult.class);
                }
                catch (Exception x) {
                    BATTestResult res = new BATTestResult();
                    res.setPass(false);
                    BATBaseElement errorStep = new BATBaseElement();
                    errorStep.setKind("InvalidResultFormat");
                    errorStep.setResult((Object)x);
                    res.setResult(new ArrayList());
                    ((ArrayList)res.getResult()).add(errorStep);
                    bATTestResult = res;
                }
                return bATTestResult;
            }
            if (object2 instanceof Object) {
                Object object3 = object2;
                BATTestResult res = new BATTestResult();
                res.setPass(false);
                BATBaseElement errorStep = new BATBaseElement();
                errorStep.setKind("InvalidResultFormat");
                errorStep.setResult(object3);
                res.setResult(new ArrayList());
                ((ArrayList)res.getResult()).add(errorStep);
                return res;
            }
            throw new MatchError(object2);
        });
    }

    public BatExecutableSpec(DataWeaveScript script) {
        this.script = script;
    }
}

