/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.Map;
import java.util.function.Function;
import org.apache.jena.mem.BunchMap;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class WrappedHashMap
implements BunchMap {
    protected final Map<Object, TripleBunch> map = CollectionFactory.createHashedMap();

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public TripleBunch get(Object key) {
        return this.map.get(key);
    }

    @Override
    public void put(Object key, TripleBunch value) {
        this.map.put(key, value);
    }

    @Override
    public TripleBunch getOrSet(Object key, Function<Object, TripleBunch> setter) {
        return this.map.computeIfAbsent(key, setter);
    }

    @Override
    public void remove(Object key) {
        this.map.remove(key);
    }

    @Override
    public ExtendedIterator<Object> keyIterator() {
        return WrappedIterator.create(this.map.keySet().iterator());
    }
}

