/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.jenax.util.RDFLabels;
import org.topbraid.shacl.expr.AppendContext;
import org.topbraid.shacl.expr.AtomicNodeExpression;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.ValidationEngineFactory;

public class FilterShapeExpression
extends ComplexNodeExpression {
    private Resource filterShape;
    private NodeExpression nodes;

    public FilterShapeExpression(NodeExpression nodes, Resource filterShape) {
        this.nodes = nodes;
        this.filterShape = filterShape;
    }

    @Override
    public void appendLabel(AppendContext context, String targetVarName) {
        if (this.nodes instanceof ComplexNodeExpression) {
            ((ComplexNodeExpression)this.nodes).appendLabel(context, targetVarName);
        }
        context.indent();
        context.append("FILTER tosh:hasShape(");
        if (this.nodes instanceof AtomicNodeExpression) {
            context.append(this.nodes.toString());
        } else {
            context.append("?" + targetVarName);
        }
        context.append(", ");
        if (this.filterShape.isURIResource()) {
            context.append(RDFLabels.get().getLabel(this.filterShape));
        } else {
            context.append("_:" + this.filterShape.asNode().getBlankNodeLabel());
        }
        context.append(") .\n");
    }

    @Override
    public List<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        for (RDFNode node : this.nodes.eval(focusNode, context)) {
            if (!this.conforms(node, context)) continue;
            results.add(node);
        }
        return results;
    }

    private boolean conforms(RDFNode node, NodeExpressionContext context) {
        ValidationEngine engine = ValidationEngineFactory.get().create(context.getDataset(), context.getShapesGraphURI(), context.getShapesGraph(), null);
        return engine.nodesConformToShape(Collections.singletonList(node), this.filterShape.asNode());
    }
}

