/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.js.model;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.topbraid.shacl.js.model.JSNamedNode;

public abstract class JSTerm {
    protected Node node;

    protected JSTerm(Node node) {
        this.node = node;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof JSTerm) {
            return this.node.equals((Object)((JSTerm)arg0).node);
        }
        return false;
    }

    public JSNamedNode getDatatype() {
        String uri = this.node.getLiteralDatatypeURI();
        return new JSNamedNode(NodeFactory.createURI((String)uri));
    }

    public String getId() {
        return this.node.getBlankNodeLabel();
    }

    public String getLanguage() {
        return this.node.getLiteralLanguage();
    }

    public String getLex() {
        return this.node.getLiteralLexicalForm();
    }

    public Node getNode() {
        return this.node;
    }

    public abstract String getTermType();

    public String getUri() {
        return this.node.getURI();
    }

    public abstract String getValue();

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean isBlankNode() {
        return this.node.isBlank();
    }

    public boolean isLiteral() {
        return this.node.isLiteral();
    }

    public boolean isURI() {
        return this.node.isURI();
    }

    public String toString() {
        return this.node.toString();
    }
}

