/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.Real;
import spire.math.RealAlgebra;
import spire.math.RealInstances;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.package$;

public final class Real$
implements RealInstances,
scala.Serializable {
    public static Real$ MODULE$;
    private Real pi;
    private Real e;
    private Real phi;
    private Real piBy2;
    private Real piBy4;
    private Real log2;
    private Real sqrt1By2;
    private final Real zero;
    private final Real one;
    private final Real two;
    private final Real four;
    private final RealAlgebra algebra;
    private final NumberTag.LargeTag<Real> RealTag;
    private volatile byte bitmap$0;

    static {
        new Real$();
    }

    @Override
    public final RealAlgebra algebra() {
        return this.algebra;
    }

    @Override
    public final NumberTag.LargeTag<Real> RealTag() {
        return this.RealTag;
    }

    @Override
    public final void spire$math$RealInstances$_setter_$algebra_$eq(RealAlgebra x$1) {
        this.algebra = x$1;
    }

    @Override
    public final void spire$math$RealInstances$_setter_$RealTag_$eq(NumberTag.LargeTag<Real> x$1) {
        this.RealTag = x$1;
    }

    public Real zero() {
        return this.zero;
    }

    public Real one() {
        return this.one;
    }

    public Real two() {
        return this.two;
    }

    public Real four() {
        return this.four;
    }

    public Real apply(Function1<Object, SafeLong> f) {
        return new Real.Inexact(f);
    }

    public Real apply(int n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(long n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(BigInt n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(SafeLong n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(Rational n) {
        return new Real.Exact(n);
    }

    public Real apply(double n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(BigDecimal n) {
        return new Real.Exact(Rational$.MODULE$.apply(n));
    }

    public Real apply(String s) {
        return new Real.Exact(Rational$.MODULE$.apply(s));
    }

    private Real pi$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.pi = this.apply(16).$times(this.atan(this.apply(Rational$.MODULE$.apply(1L, 5L)))).$minus(this.four().$times(this.atan(this.apply(Rational$.MODULE$.apply(1L, 239L)))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.pi;
    }

    public Real pi() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.pi$lzycompute() : this.pi;
    }

    private Real e$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.e = this.exp(this.one());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.e;
    }

    public Real e() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.e$lzycompute() : this.e;
    }

    private Real phi$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.phi = this.one().$plus(this.apply(5).sqrt()).$div(this.two());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.phi;
    }

    public Real phi() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.phi$lzycompute() : this.phi;
    }

    public Real log(Real x) {
        SafeLong t = x.apply(2);
        int n = this.sizeInBase(t, 2) - 3;
        if (t.$less((Object)SafeLong$.MODULE$.apply(0L))) {
            throw new ArithmeticException("log of negative number");
        }
        return t.$less((Object)SafeLong$.MODULE$.apply(4L)) ? this.log(x.reciprocal()).unary_$minus() : (t.$less((Object)SafeLong$.MODULE$.apply(8L)) ? this.logDr(x) : this.logDr(this.div2n(x, n)).$plus(this.apply(n).$times(this.log2())));
    }

    public Real exp(Real x) {
        Real u = x.$div(this.log2());
        SafeLong n = u.apply(0);
        Real s = x.$minus(this.apply(n).$times(this.log2()));
        if (!n.isValidInt()) {
            throw new ArithmeticException("invalid power in exp");
        }
        return n.$less((Object)SafeLong$.MODULE$.apply(0L)) ? this.div2n(this.expDr(s), -n.toInt()) : (n.$greater((Object)SafeLong$.MODULE$.apply(0L)) ? this.mul2n(this.expDr(s), n.toInt()) : this.expDr(s));
    }

    public Real sin(Real x) {
        Real real;
        int n;
        Real z = x.$div(this.piBy4());
        SafeLong s = this.roundUp(Rational$.MODULE$.apply(z.apply(2), SafeLong$.MODULE$.apply(4L)));
        Real y = x.$minus(this.piBy4().$times(this.apply(s)));
        int m = s.$percent(8L).toInt();
        int n2 = n = m < 0 ? m + 8 : m;
        switch (n2) {
            case 0: {
                real = this.sinDr(y);
                break;
            }
            case 1: {
                real = this.sqrt1By2().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 2: {
                real = this.cosDr(y);
                break;
            }
            case 3: {
                real = this.sqrt1By2().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 4: {
                real = this.sinDr(y).unary_$minus();
                break;
            }
            case 5: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 6: {
                real = this.cosDr(y).unary_$minus();
                break;
            }
            case 7: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
        }
        return real;
    }

    public Real cos(Real x) {
        Real real;
        int n;
        Real z = x.$div(this.piBy4());
        SafeLong s = this.roundUp(Rational$.MODULE$.apply(z.apply(2), SafeLong$.MODULE$.apply(4L)));
        Real y = x.$minus(this.piBy4().$times(this.apply(s)));
        int m = s.$percent(8L).toInt();
        int n2 = n = m < 0 ? m + 8 : m;
        switch (n2) {
            case 0: {
                real = this.cosDr(y);
                break;
            }
            case 1: {
                real = this.sqrt1By2().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 2: {
                real = this.sinDr(y).unary_$minus();
                break;
            }
            case 3: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            case 4: {
                real = this.cosDr(y).unary_$minus();
                break;
            }
            case 5: {
                real = this.sqrt1By2().unary_$minus().$times(this.cosDr(y).$minus(this.sinDr(y)));
                break;
            }
            case 6: {
                real = this.sinDr(y);
                break;
            }
            case 7: {
                real = this.sqrt1By2().$times(this.cosDr(y).$plus(this.sinDr(y)));
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
        }
        return real;
    }

    public Real tan(Real x) {
        return this.sin(x).$div(this.cos(x));
    }

    public Real atan(Real x) {
        SafeLong t = x.apply(2);
        Real xp1 = x.$plus(this.one());
        Real xm1 = x.$minus(this.one());
        return t.$less((Object)SafeLong$.MODULE$.apply(-5L)) ? this.atanDr(x.reciprocal().unary_$minus()).$minus(this.piBy2()) : (BoxesRunTime.equalsNumObject((Number)((Object)t), (Object)BoxesRunTime.boxToInteger((int)-4)) ? this.piBy4().unary_$minus().$minus(this.atanDr(xp1.$div(xm1))) : (t.$less((Object)SafeLong$.MODULE$.apply(4L)) ? this.atanDr(x) : (BoxesRunTime.equalsNumObject((Number)((Object)t), (Object)BoxesRunTime.boxToInteger((int)4)) ? this.piBy4().$plus(this.atanDr(xm1.$div(xp1))) : this.piBy2().$minus(this.atanDr(x.reciprocal())))));
    }

    public Real atan2(Real y, Real x) {
        return this.apply((Function1<Object, SafeLong>)(Function1 & Serializable & scala.Serializable)p -> Real$.$anonfun$atan2$1(this, y, x, BoxesRunTime.unboxToInt((Object)p)));
    }

    public Real asin(Real x) {
        SafeLong x0 = x.apply(0);
        Real s = this.one().$minus(x.$times(x)).sqrt();
        int n = x0.signum();
        Real real = n > 0 ? this.pi().$div(this.two()).$minus(this.atan(s.$div(x))) : (0 == n ? this.atan(x.$div(s)) : this.pi().unary_$minus().$div(this.two()).$minus(this.atan(s.$div(x))));
        return real;
    }

    public Real acos(Real x) {
        return this.pi().$div(this.two()).$minus(this.asin(x));
    }

    public Real sinh(Real x) {
        Real y = this.exp(x);
        return y.$minus(y.reciprocal()).$div(this.two());
    }

    public Real cosh(Real x) {
        Real y = this.exp(x);
        return y.$plus(y.reciprocal()).$div(this.two());
    }

    public Real tanh(Real x) {
        Real y = this.exp(x);
        Real y2 = y.reciprocal();
        return y.$minus(y2).$div(y.$plus(y2));
    }

    public Real asinh(Real x) {
        return this.log(x.$plus(x.$times(x).$plus(this.one()).sqrt()));
    }

    public Real acosh(Real x) {
        return this.log(x.$plus(x.$times(x).$minus(this.one()).sqrt()));
    }

    public Real atanh(Real x) {
        return this.log(this.one().$plus(x).$div(this.one().$minus(x))).$div(this.two());
    }

    public int digits() {
        return 40;
    }

    public int bits() {
        return this.digitsToBits(this.digits());
    }

    public int digitsToBits(int n) {
        return (int)package$.MODULE$.ceil((double)n * (package$.MODULE$.log(10.0) / package$.MODULE$.log(2.0))) + 4;
    }

    public int sizeInBase(SafeLong n, int base) {
        return this.loop$2(n.abs(), 0, base);
    }

    public SafeLong roundUp(Rational r) {
        return SafeLong$.MODULE$.apply(r.round().toBigInt());
    }

    public Real div2n(Real x, int n) {
        return this.apply((Function1<Object, SafeLong>)(Function1 & Serializable & scala.Serializable)p -> Real$.$anonfun$div2n$1(this, x, n, BoxesRunTime.unboxToInt((Object)p)));
    }

    public Real mul2n(Real x, int n) {
        return this.apply((Function1<Object, SafeLong>)(Function1 & Serializable & scala.Serializable)p -> x.apply(BoxesRunTime.unboxToInt((Object)p) + n));
    }

    private Real piBy2$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.piBy2 = this.div2n(this.pi(), 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.piBy2;
    }

    public Real piBy2() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.piBy2$lzycompute() : this.piBy2;
    }

    private Real piBy4$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.piBy4 = this.div2n(this.pi(), 2);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.piBy4;
    }

    public Real piBy4() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.piBy4$lzycompute() : this.piBy4;
    }

    private Real log2$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.log2 = this.div2n(this.logDrx(this.two().reciprocal()), 1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.log2;
    }

    public Real log2() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.log2$lzycompute() : this.log2;
    }

    private Real sqrt1By2$lzycompute() {
        Real$ real$ = this;
        synchronized (real$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.sqrt1By2 = this.two().reciprocal().sqrt();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.sqrt1By2;
    }

    public Real sqrt1By2() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.sqrt1By2$lzycompute() : this.sqrt1By2;
    }

    public SafeLong accumulate(SafeLong total, Stream<SafeLong> xs, Stream<Rational> cs) {
        SafeLong safeLong;
        block3: {
            Tuple2 tuple2;
            block4: {
                while (true) {
                    Stream stream;
                    Stream stream2;
                    if ((tuple2 = new Tuple2(xs, cs)) != null && Stream.Empty$.MODULE$.equals(stream2 = (Stream)tuple2._2())) {
                        safeLong = total;
                        break block3;
                    }
                    if (tuple2 != null && Stream.Empty$.MODULE$.equals(stream = (Stream)tuple2._1())) {
                        throw scala.sys.package$.MODULE$.error("nooooo");
                    }
                    if (tuple2 == null) break block4;
                    Stream stream3 = (Stream)tuple2._1();
                    Stream stream4 = (Stream)tuple2._2();
                    Option option = scala.package$.MODULE$.$hash$colon$colon().unapply(stream3);
                    if (option.isEmpty()) break block4;
                    SafeLong x = (SafeLong)((Object)((Tuple2)option.get())._1());
                    Stream xs2 = (Stream)((Tuple2)option.get())._2();
                    Option option2 = scala.package$.MODULE$.$hash$colon$colon().unapply(stream4);
                    if (option2.isEmpty()) break block4;
                    Rational c = (Rational)((Object)((Tuple2)option2.get())._1());
                    Stream cs2 = (Stream)((Tuple2)option2.get())._2();
                    SafeLong t = this.roundUp(c.$times(Rational$.MODULE$.apply(x)));
                    if (BoxesRunTime.equalsNumObject((Number)((Object)t), (Object)BoxesRunTime.boxToInteger((int)0))) break;
                    cs = cs2;
                    xs = xs2;
                    total = total.$plus(t);
                }
                safeLong = total;
                break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        return safeLong;
    }

    public Real powerSeries(Stream<Rational> ps, Function1<Object, Object> terms, Real x) {
        return this.apply((Function1<Object, SafeLong>)(Function1 & Serializable & scala.Serializable)p -> Real$.$anonfun$powerSeries$1(this, ps, terms, x, BoxesRunTime.unboxToInt((Object)p)));
    }

    public Stream<Rational> accSeq(Function2<Rational, SafeLong, Rational> f) {
        return Real$.loop$3(Rational$.MODULE$.one(), SafeLong$.MODULE$.one(), f);
    }

    public Real expDr(Real x) {
        return this.powerSeries(this.accSeq((Function2<Rational, SafeLong, Rational>)(Function2 & Serializable & scala.Serializable)(r, n) -> r.$div(Rational$.MODULE$.apply((SafeLong)((Object)n)))), (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)n -> n, x);
    }

    public Real logDr(Real x) {
        Real y = x.$minus(this.one()).$div(x);
        return y.$times(this.logDrx(y));
    }

    public Real logDrx(Real x) {
        return this.powerSeries((Stream<Rational>)((Stream)scala.package$.MODULE$.Stream().from(1).map((Function1 & Serializable & scala.Serializable)n -> Rational$.MODULE$.apply(1L, BoxesRunTime.unboxToInt((Object)n)), Stream$.MODULE$.canBuildFrom())), (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$3 -> x$3 + 1, x);
    }

    public Real sinDr(Real x) {
        return x.$times(this.powerSeries(this.accSeq((Function2<Rational, SafeLong, Rational>)(Function2 & Serializable & scala.Serializable)(r, n) -> r.unary_$minus().$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(1L), SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$times(SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$plus(1L))))), (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)n -> n, x.$times(x)));
    }

    public Real cosDr(Real x) {
        return this.powerSeries(this.accSeq((Function2<Rational, SafeLong, Rational>)(Function2 & Serializable & scala.Serializable)(r, n) -> r.unary_$minus().$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(1L), SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$times(SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$minus(1L))))), (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)n -> n, x.$times(x));
    }

    public Real atanDr(Real x) {
        Real y = x.$times(x).$plus(this.apply(1));
        return x.$div(y).$times(this.atanDrx(x.$times(x).$div(y)));
    }

    public Real atanDrx(Real x) {
        return this.powerSeries(this.accSeq((Function2<Rational, SafeLong, Rational>)(Function2 & Serializable & scala.Serializable)(r, n) -> r.$times(Rational$.MODULE$.apply(SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)), SafeLong$.MODULE$.apply(2L).$times((SafeLong)((Object)n)).$plus(1L)))), (Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$4 -> x$4 * 2, x);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ SafeLong $anonfun$atan2$1(Real$ $this, Real y$6, Real x$7, int p) {
        SafeLong safeLong;
        int pp = p;
        int sx = x$7.apply(pp).signum();
        int sy = y$6.apply(pp).signum();
        while (sx == 0 && sy == 0) {
            sx = x$7.apply(pp).signum();
            sy = y$6.apply(pp).signum();
            ++pp;
        }
        if (sx > 0) {
            safeLong = $this.atan(y$6.$div(x$7)).apply(p);
        } else if (sy >= 0 && sx < 0) {
            safeLong = $this.atan(y$6.$div(x$7)).$plus(MODULE$.pi()).apply(p);
        } else if (sy < 0 && sx < 0) {
            safeLong = $this.atan(y$6.$div(x$7)).$minus(MODULE$.pi()).apply(p);
        } else if (sy > 0) {
            safeLong = MODULE$.pi().$div(MODULE$.two()).apply(p);
        } else if (sy < 0) {
            safeLong = MODULE$.pi().unary_$minus().$div(MODULE$.two()).apply(p);
        } else {
            throw new IllegalArgumentException("atan2(0, 0) is undefined");
        }
        return safeLong;
    }

    private final int loop$2(SafeLong n, int acc, int base$1) {
        while (!n.$less$eq((Object)SafeLong$.MODULE$.apply(1L))) {
            ++acc;
            n = n.$div(base$1);
        }
        return acc + 1;
    }

    public static final /* synthetic */ SafeLong $anonfun$div2n$1(Real$ $this, Real x$5, int n$1, int p) {
        return p >= n$1 ? x$5.apply(p - n$1) : $this.roundUp(Rational$.MODULE$.apply(x$5.apply(p), SafeLong$.MODULE$.two().pow(n$1)));
    }

    private final SafeLong g$1(SafeLong yn, SafeLong xr$1, SafeLong xn$1) {
        return this.roundUp(Rational$.MODULE$.apply(yn.$times(xr$1), xn$1));
    }

    public static final /* synthetic */ SafeLong $anonfun$powerSeries$1(Real$ $this, Stream ps$1, Function1 terms$1, Real x$8, int p) {
        int t = terms$1.apply$mcII$sp(p);
        int l2t = 2 * $this.sizeInBase(SafeLong$.MODULE$.apply(t).$plus(1L), 2) + 6;
        int p2 = p + l2t;
        SafeLong xr = x$8.apply(p2);
        SafeLong xn = SafeLong$.MODULE$.two().pow(p2);
        if (BoxesRunTime.equalsNumObject((Number)((Object)xn), (Object)BoxesRunTime.boxToInteger((int)0))) {
            throw scala.sys.package$.MODULE$.error("oh no");
        }
        SafeLong num = $this.accumulate(SafeLong$.MODULE$.zero(), (Stream<SafeLong>)scala.package$.MODULE$.Stream().iterate((Object)xn, (Function1 & Serializable & scala.Serializable)yn -> $this.g$1((SafeLong)((Object)yn), xr, xn)), (Stream<Rational>)ps$1.take(t));
        SafeLong denom = SafeLong$.MODULE$.two().pow(l2t);
        return $this.roundUp(Rational$.MODULE$.apply(num, denom));
    }

    private static final Stream loop$3(Rational r, SafeLong n, Function2 f$1) {
        Rational rational = r;
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> Real$.loop$3((Rational)((Object)((Object)f$1.apply((Object)r, (Object)n))), n.$plus(1L), f$1)).$hash$colon$colon((Object)rational);
    }

    private Real$() {
        MODULE$ = this;
        RealInstances.$init$(this);
        this.zero = new Real.Exact(Rational$.MODULE$.zero());
        this.one = new Real.Exact(Rational$.MODULE$.one());
        this.two = new Real.Exact(Rational$.MODULE$.apply(2));
        this.four = new Real.Exact(Rational$.MODULE$.apply(4));
    }
}

