%dw 2.0
output application/json

import DEBUG from bat::core::Console
import * from dw::http::Client
import generateBody from dw::http::BodyUtils
import * from bat::Reporters::Common

fun mockedNow() = if(DEBUG) |2017-10-10T15:10:29| else now()

fun endpoint(): String =
  if(options != null and options.URL != null)
    options.URL default ''
  else
    log('Missing URL option for custom report', '')

fun headers(): { _?: SimpleType } =
  if(options != null and options.HEADERS != null )
    {(options.HEADERS replace "'" with "" splitBy "," map (pair) ->
        using(keyValue = pair splitBy ":") {
            (keyValue[0]): keyValue[1]
        }
    )}
  else {}

var disabled = isDisabled(options, context)

---
if (DEBUG or endpoint() == '' or disabled)
  payload
else
  (request('POST', endpoint(), generateBody({
     body: payload,
     headers:headers() default {}
  })))
