%dw 2.0
output application/json

import * from bat::Types
import DEBUG from bat::core::Console
import sanitizeName from bat::core::Helpers
import getHttpElements from bat::core::Helpers
import * from bat::Reporters::Common
import * from dw::http::Client
import envVar from dw::System

fun getAttributes(httpCall) =
{
  "method": httpCall.result.request.method,
  "url": httpCall.result.request.url default '',
  "path": httpCall.result.request.path default '',
  "statusCode": httpCall.result.response.status as String default ''
 }

fun generateMetricItem(metricName, httpCall) =
{
  "name": metricName,
  "type": "gauge",
  "value": httpCall.result.timers[metricName] default 0,
  "attributes": getAttributes(httpCall)
 }

 fun getCommonMetric() = {
   "name": "successfully-afm-execution",
   "type": "gauge",
   "value": if(payload.pass) 1 else 0,
   "attributes": {}
 }

fun generateMetricsBlock(httpCall) =
 [
    generateMetricItem("blocked", httpCall),
    generateMetricItem("dns", httpCall),
    generateMetricItem("wait", httpCall),
    generateMetricItem("connect", httpCall),
    generateMetricItem("ssl", httpCall),
    generateMetricItem("receive", httpCall),
    generateMetricItem("send", httpCall),
    generateMetricItem("total", httpCall)
  ]

fun generateNewRelicBody(httpElements, pass) =
    if (pass)
        (httpElements map generateMetricsBlock($)) ++ [getCommonMetric()]
    else
        [getCommonMetric()]

fun getFirstStartDate(httpElements) =
    (flatten(httpElements.startDate) filter ((item) -> item != null))[0]

fun processAndExtractDate(httpElements) =
  (getFirstStartDate(httpElements) as DateTime >> "UCT") as Number {unit: "milliseconds"}
  // Taking this instead of take the payload.startDate because the payload.startDate doesn't have the timezone.

fun licenseKey() = getReporterProperty(options, "NEW_RELIC_LICENSE_KEY")

fun getNowMillisTime() = now() as Number {unit: "milliseconds"}

fun toNewRelicNew() = do {
var httpElements = getHttpElements(payload, payload.name  default '', '')
var analyticsBody = flatten(generateNewRelicBody(httpElements, payload.pass))
var startDate = processAndExtractDate(httpElements)  default getNowMillisTime()
---
[
    {"common": {
        "timestamp": startDate,
        "attributes": {
            "monitorName": payload.name,
            "configuration": payload.metadata.configuration default 'default',
            "testId": payload.metadata.testId default '',
            "organizationId": payload.metadata.organizationId default '',
            "executionId": payload.metadata.executionId default '',
            "targetId": payload.metadata.targetId default '',
            "pass": payload.pass as String,
            "agent": "Api Functional Monitoring"
            }
        },
        "metrics": analyticsBody
    }]
}

var disabled = isDisabled(options, context)
---
if (DEBUG or licenseKey() == '' or disabled)
  toNewRelicNew()
else
request('POST', 'https://metric-api.newrelic.com/metric/v1', {
    body: toNewRelicNew(),
    headers: {
      'X-License-Key': licenseKey(),
      'Content-Type' : 'application/json'
    }
  })
