ns bat http://mulesoft.com/ns/bat

type EveryItem<T> = {
  bat#everyItem: Boolean,
  bat#items: Array<T>
}

type MatchesOneOf<T> = {
  bat#matchesOneOf: Boolean,
  bat#items: Array<T>
}

fun matchPrinter_(a: Any): String =
  a match {
    case a if isOneOf_(a) -> 'one of $(matchPrinter_((a as Object).bat#items))'
    case a if isEvery_(a) -> 'every value in $(matchPrinter_((a as Object).bat#items))'
    case a if isSome_(a) -> 'at least one value in $(matchPrinter_((a as Object).bat#items))'
    case a is Array -> '[' ++ (a map matchPrinter_($) joinBy ', ') ++ ']'
    case a is Regex -> 'Regex /' ++ a as String ++ '/'
    else -> write(a) as String
  }

fun computeEvery_<T>(items: Array<T>, fn: (a: T) -> Boolean): Boolean =
  (items reduce (a, acc = true) -> (acc and fn(a))) default false

fun computeSome_<T>(items: Array<T>, fn: (a: T) -> Boolean): Boolean =
  (items reduce (a, acc = false) -> (acc or fn(a))) default false

fun isSome_<T>(a: T): Boolean =
  a is Object and (a as Object).bat#everyItem == false and (a as Object).bat#items?

fun isEvery_<T>(a: T): Boolean =
  a is Object and (a as Object).bat#everyItem == true and (a as Object).bat#items?

fun isOneOf_<T>(a: T): Boolean =
  a is Object and (a as Object).bat#matchesOneOf == true and (a as Object).bat#items?