/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.mojo;

import static java.lang.String.format;
import static java.nio.file.Files.exists;

import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;

import com.mulesoft.connectivity.rest.commons.parent.mojo.CommonsAbstractMojo;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class BaseRestCommonsMojo extends CommonsAbstractMojo {

  protected static final String META_INF = "META-INF";
  protected static final String MULE_ARTIFACT = "mule-artifact";
  protected static final String MULE_ARTIFACT_JSON = MULE_ARTIFACT + ".json";

  protected String getMuleArtifact(Path muleArtifactPath) throws MojoExecutionException {
    if (!exists(muleArtifactPath)) {
      throw new MojoExecutionException(format("Mule artifact file not found at: %s. This is a bug", muleArtifactPath));
    }

    String muleArtifact;
    try {
      muleArtifact = IOUtils.toString(new FileReader(muleArtifactPath.toFile()));
    } catch (IOException e) {
      throw new MojoExecutionException(format("Failed to validate mule artifact file: %s", e.getMessage()));
    }
    return muleArtifact;
  }
}
