/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.mojo;

import static java.lang.String.format;
import static java.lang.String.join;
import static org.apache.maven.plugins.annotations.LifecyclePhase.VERIFY;

import org.mule.runtime.api.deployment.meta.MulePluginModel;
import org.mule.runtime.api.deployment.persistence.MulePluginModelJsonSerializer;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name = "ValidateExportedPackages", defaultPhase = VERIFY)
public class ValidateExportedPackagesMojo extends BaseRestCommonsMojo {

  @Parameter(property = "rest.connector.commons.skipValidation", defaultValue = "false")
  private boolean skipValidation;

  @Parameter(property = "rest.connector.commons.allowList")
  private List<String> allowList;

  @Override
  protected void doExecute() throws MojoExecutionException {
    if (skipValidation) {
      getLog().warn("Skipping exported packages validation");
      return;
    }

    final Path muleArtifactPath = Paths.get(project.getBuild().getOutputDirectory(), META_INF, MULE_ARTIFACT, MULE_ARTIFACT_JSON);
    String muleArtifact = getMuleArtifact(muleArtifactPath);
    MulePluginModel mulePluginModel = new MulePluginModelJsonSerializer().deserialize(muleArtifact);
    List<String> exportedPackages =
        (List<String>) mulePluginModel.getClassLoaderModelLoaderDescriptor().getAttributes().get("exportedPackages");
    exportedPackages.removeAll(allowList);

    if (!allowList.isEmpty()) {
      getLog().warn(format("The following packages were allowed to be exported during this mule plugin: [%s] \n",
                           join(",", allowList)));
    }

    if (!exportedPackages.isEmpty()) {
      throw new MojoExecutionException(format("Citizen connectors must not export any package, and found the following list [%s].\n"
          +
          "For exceptions, refer to the parameter 'rest.connector.commons.allowList'", join(",", exportedPackages)));
    }

  }

}
