/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.api;

import static com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkMessage.RestSdkMessageKind.ERROR;
import static com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkMessage.RestSdkMessageKind.INFO;
import static com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkMessage.RestSdkMessageKind.WARNING;

import java.util.ArrayList;
import java.util.List;

public class RestSdkMessageCollector {

  private final List<RestSdkMessage> messages;

  public RestSdkMessageCollector() {
    this.messages = new ArrayList<>();
  }

  public void addWarning(String message) {
    messages.add(new RestSdkMessage(WARNING, message));
  }

  public void addError(String message) {
    messages.add(new RestSdkMessage(ERROR, message));
  }

  public void addInfo(String message) {
    messages.add(new RestSdkMessage(INFO, message));
  }

  public List<RestSdkMessage> messages() {
    return this.messages;
  }
}
