/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory.PREMIUM;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory.SELECT;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.VelocityTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;

public class SdkLicenseHeader extends VelocityTemplateEntity {

  private static final List<ConnectorCategory> LICENSED_CONNECTOR_CATEGORIES = Arrays.asList(SELECT, PREMIUM);

  private static final String LICENSE_VM = "templates/sdk/licenseHeader.vm";

  private final ConnectorModel model;

  public SdkLicenseHeader(Path outputDir, ConnectorModel connectorModel) {
    super(outputDir);
    this.model = connectorModel;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    if (LICENSED_CONNECTOR_CATEGORIES.contains(model.getCategory())) {
      applyTemplate(LICENSE_VM, outputDir.resolve("LICENSE_HEADER.txt"));
    }
  }
}
