/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection;

import static com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy.getStrategy;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.SdkConnectionProviderBaseLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.SdkConnectionProviderRefinementLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.SdkConnectorProviderImplementationLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.model.SdkHttpProxyConfig;

import java.nio.file.Path;

import com.squareup.javapoet.TypeName;

public class SdkConnectionProvider extends AbstractSdkConnectionProvider {

  private final SdkConnectionProviderBaseLayer baseLayer;
  private final SdkConnectionProviderRefinementLayer refinementLayer;
  private final SdkConnectorProviderImplementationLayer implementationLayer;

  public SdkConnectionProvider(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                               ConnectorSecurityScheme securityScheme, SdkHttpProxyConfig httpProxyConfig,
                               RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, runConfiguration);

    SdkAuthenticationStrategy authenticationStrategy = getStrategy(securityScheme);

    baseLayer = new SdkConnectionProviderBaseLayer(outputDir,
                                                   sdkConnector,
                                                   connectorModel,
                                                   securityScheme,
                                                   authenticationStrategy,
                                                   httpProxyConfig,
                                                   runConfiguration);

    refinementLayer = new SdkConnectionProviderRefinementLayer(outputDir,
                                                               connectorModel,
                                                               securityScheme,
                                                               authenticationStrategy,
                                                               baseLayer.getTypeName(),
                                                               runConfiguration);

    implementationLayer = new SdkConnectorProviderImplementationLayer(outputDir,
                                                                      connectorModel,
                                                                      securityScheme,
                                                                      authenticationStrategy,
                                                                      refinementLayer.getTypeName(),
                                                                      runConfiguration);
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    baseLayer.applyTemplates();
    refinementLayer.applyTemplates();
    implementationLayer.applyTemplates();
  }

  @Override
  public TypeName getTypeNameForConfig() {
    return implementationLayer.getTypeName();
  }

}
