/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import static com.google.common.base.CaseFormat.LOWER_CAMEL;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.generateGetter;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.getDisplayNameAnnotation;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.getSummaryAnnotation;
import static javax.lang.model.element.Modifier.PROTECTED;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.semantics.security.SecretToken;

import com.mulesoft.connectivity.rest.commons.api.connection.BearerAuthenticationConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BearerAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.BearerAuthScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;

public class SdkBearerAuthenticationStrategy extends SdkAuthenticationStrategy {

  public static final String TOKEN_FIELD = "token";
  public static final String TOKEN_FIELD_DEFAULT_DISPLAY_NAME = "Token";
  public static final String TOKEN_FIELD_DEFAULT_SUMMARY = "The token used to authenticate the requests.";

  protected SdkBearerAuthenticationStrategy(
                                            ConnectorSecurityScheme securityScheme) {
    super(securityScheme);
  }

  @Override
  public Class<?> getCommonsBaseClass() {
    return BearerAuthenticationConnectionProvider.class;
  }

  @Override
  public void addClassAnnotations(TypeSpec.Builder connectionProviderClassBuilder) {

  }

  @Override
  public void addDefaultClassMembers(TypeSpec.Builder connectionProviderClassBuilder) {
    addTokenParameterField(connectionProviderClassBuilder);
  }

  protected void addTokenParameterField(TypeSpec.Builder classBuilder) {

    BearerAuthDefaultParameters bearerAuthDefaultParameters =
        ((BearerAuthScheme) securityScheme).getBearerAuthDefaultParameters();

    String displayName = TOKEN_FIELD_DEFAULT_DISPLAY_NAME;
    String summary = TOKEN_FIELD_DEFAULT_SUMMARY;

    if (bearerAuthDefaultParameters != null) {
      displayName = defaultIfNull(bearerAuthDefaultParameters.getToken().getDisplayName(), displayName);
      summary = defaultIfNull(bearerAuthDefaultParameters.getToken().getDescription(), summary);
    }

    FieldSpec fieldSpec = FieldSpec
        .builder(String.class, TOKEN_FIELD, PROTECTED)
        .addAnnotation(Parameter.class)
        .addAnnotation(SecretToken.class)
        .addAnnotation(getDisplayNameAnnotation(displayName))
        .addAnnotation(getSummaryAnnotation(summary))
        .build();

    MethodSpec getter = generateGetter(fieldSpec, LOWER_CAMEL, PROTECTED)
        .addAnnotation(Override.class)
        .build();

    classBuilder
        .addField(fieldSpec)
        .addMethod(getter);
  }
}
