/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;

import com.mulesoft.connectivity.rest.commons.api.connection.oauth.BaseClientCredentialsConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2ClientCredentialsScheme;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeSpec;

public class SdkClientCredentialsAuthenticationStrategy extends SdkOAuthAuthenticationStrategy {

  public static final String TOKEN_URL = "tokenUrl";
  protected final OAuth2ClientCredentialsScheme clientCredentials;

  protected SdkClientCredentialsAuthenticationStrategy(ConnectorSecurityScheme securityScheme) {
    super(securityScheme);
    clientCredentials = (OAuth2ClientCredentialsScheme) securityScheme;
  }

  @Override
  public Class<?> getCommonsBaseClass() {
    return BaseClientCredentialsConnectionProvider.class;
  }

  @Override
  public void addClassAnnotations(TypeSpec.Builder connectionProviderClassBuilder) {
    AnnotationSpec oAuthAnnotation = AnnotationSpec
        .builder(ClientCredentials.class)
        .addMember(TOKEN_URL, "$S", clientCredentials.getAccessTokenUri())
        .addMember(DEFAULT_SCOPES, "$S", clientCredentials.getScopes())
        .build();

    connectionProviderClassBuilder.addAnnotation(oAuthAnnotation);
  }
}
