/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import com.mulesoft.connectivity.rest.commons.api.connection.DigestConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.DigestAuthenticationScheme;

import com.squareup.javapoet.TypeSpec;

public class SdkDigestAuthenticationStrategy extends SdkUserPasswordAuthenticationStrategy {

  private final DigestAuthenticationScheme digestAuthenticationScheme;

  protected SdkDigestAuthenticationStrategy(
                                            ConnectorSecurityScheme securityScheme) {
    super(securityScheme);
    this.digestAuthenticationScheme = (DigestAuthenticationScheme) securityScheme;

  }

  @Override
  protected SecurityDefaultParameter getUsernameDefaultParameter() {
    if (digestAuthenticationScheme.getDigestAuthDefaultParameters() == null) {
      return null;
    }
    return digestAuthenticationScheme.getDigestAuthDefaultParameters().getUsername();
  }

  @Override
  protected SecurityDefaultParameter getPasswordDefaultParameter() {
    if (digestAuthenticationScheme.getDigestAuthDefaultParameters() == null) {
      return null;
    }
    return digestAuthenticationScheme.getDigestAuthDefaultParameters().getPassword();
  }

  @Override
  public Class<?> getCommonsBaseClass() {
    return DigestConnectionProvider.class;
  }

  @Override
  public void addClassAnnotations(TypeSpec.Builder connectionProviderClassBuilder) {

  }
}
