/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import static javax.lang.model.element.Modifier.PUBLIC;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.OAuth2Scheme;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;

public abstract class SdkOAuthAuthenticationStrategy extends SdkAuthenticationStrategy {

  public static final String DEFAULT_SCOPES = "defaultScopes";

  protected SdkOAuthAuthenticationStrategy(
                                           ConnectorSecurityScheme securityScheme) {
    super(securityScheme);
  }

  protected void addGetRefreshTokenConditionExpressionConfigMethod(String expression,
                                                                   TypeSpec.Builder connectionProviderClassBuilder) {
    CodeBlock methodBody = CodeBlock.builder()
        .addStatement("return $S", expression)
        .build();

    MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder("getRefreshTokenCondition")
        .returns(TypeName.get(String.class))
        .addModifiers(PUBLIC)
        .addAnnotation(Override.class)
        .addCode(methodBody)
        .build();

    connectionProviderClassBuilder.addMethod(getCategoryNameMethod);
  }

  @Override
  public void addDefaultClassMembers(TypeSpec.Builder connectionProviderClassBuilder) {
    ((OAuth2Scheme) securityScheme).getRefreshTokenConditionExpression()
        .ifPresent(expression -> addGetRefreshTokenConditionExpressionConfigMethod(expression,
                                                                                   connectionProviderClassBuilder));
  }

  @Override
  public FieldSpec.Builder getParameterField(SdkParameter parameter) {
    return parameter.generateOAuthParameterField();
  }

  @Override
  public boolean canOverrideCreateConnectionMethod() {
    return false;
  }
}
