/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication;

import static com.google.common.base.CaseFormat.LOWER_CAMEL;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.generateGetter;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.getDisplayNameAnnotation;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.getSummaryAnnotation;
import static javax.lang.model.element.Modifier.PROTECTED;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Username;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;

import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;

public abstract class SdkUserPasswordAuthenticationStrategy extends SdkAuthenticationStrategy {

  public static final String USERNAME_FIELD = "username";
  public static final String PASSWORD_FIELD = "password";

  public static final String USERNAME_FIELD_DEFAULT_DISPLAY_NAME = "Username";
  public static final String USERNAME_FIELD_DEFAULT_SUMMARY = "The username used to authenticate the requests.";

  public static final String PASSWORD_FIELD_DEFAULT_DISPLAY_NAME = "Password";
  public static final String PASSWORD_FIELD_DEFAULT_SUMMARY = "The password used to authenticate the requests.";

  protected SdkUserPasswordAuthenticationStrategy(
                                                  ConnectorSecurityScheme securityScheme) {
    super(securityScheme);
  }

  protected abstract SecurityDefaultParameter getUsernameDefaultParameter();

  protected abstract SecurityDefaultParameter getPasswordDefaultParameter();

  protected void addUsernameParameterField(TypeSpec.Builder classBuilder) {
    String displayName = USERNAME_FIELD_DEFAULT_DISPLAY_NAME;
    String summary = USERNAME_FIELD_DEFAULT_SUMMARY;

    SecurityDefaultParameter usernameDefaultParameter = getUsernameDefaultParameter();

    if (usernameDefaultParameter != null) {
      displayName = defaultIfNull(usernameDefaultParameter.getDisplayName(), displayName);
      summary = defaultIfNull(usernameDefaultParameter.getDescription(), summary);
    }

    FieldSpec fieldSpec = FieldSpec
        .builder(String.class, USERNAME_FIELD, PROTECTED)
        .addAnnotation(Parameter.class)
        .addAnnotation(Username.class)
        .addAnnotation(getDisplayNameAnnotation(displayName))
        .addAnnotation(getSummaryAnnotation(summary))
        .build();

    MethodSpec getter = generateGetter(fieldSpec, LOWER_CAMEL, PROTECTED)
        .addAnnotation(Override.class)
        .build();

    classBuilder
        .addField(fieldSpec)
        .addMethod(getter);
  }

  protected void addPasswordParameterField(TypeSpec.Builder classBuilder) {
    String displayName = PASSWORD_FIELD_DEFAULT_DISPLAY_NAME;
    String summary = PASSWORD_FIELD_DEFAULT_SUMMARY;

    SecurityDefaultParameter passwordDefaultParameter = getPasswordDefaultParameter();

    if (passwordDefaultParameter != null) {
      displayName = defaultIfNull(passwordDefaultParameter.getDisplayName(), displayName);
      summary = defaultIfNull(passwordDefaultParameter.getDescription(), summary);
    }

    FieldSpec fieldSpec = FieldSpec
        .builder(String.class, PASSWORD_FIELD, PROTECTED)
        .addAnnotation(Parameter.class)
        .addAnnotation(Password.class)
        .addAnnotation(Optional.class)
        .addAnnotation(getDisplayNameAnnotation(displayName))
        .addAnnotation(getSummaryAnnotation(summary))
        .build();

    MethodSpec getter = generateGetter(fieldSpec, LOWER_CAMEL, PROTECTED)
        .addAnnotation(Override.class)
        .build();

    classBuilder
        .addField(fieldSpec)
        .addMethod(getter);
  }

  @Override
  public void addDefaultClassMembers(TypeSpec.Builder connectionProviderClassBuilder) {
    addUsernameParameterField(connectionProviderClassBuilder);
    addPasswordParameterField(connectionProviderClassBuilder);
  }
}
