/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.authentication.SdkAuthenticationStrategy;

import java.nio.file.Path;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public abstract class AbstractSdkConnectionProviderLayer extends JavaTemplateEntity {

  public static final String CONNECTION_PROVIDER_CLASSNAME_SUFFIX = "ConnectionProvider";

  protected final RestSdkRunConfiguration runConfiguration;

  protected final ConnectorSecurityScheme securityScheme;
  protected final SdkAuthenticationStrategy authenticationStrategy;

  public AbstractSdkConnectionProviderLayer(Path outputDir,
                                            ConnectorModel connectorModel,
                                            ConnectorSecurityScheme securityScheme,
                                            SdkAuthenticationStrategy authenticationStrategy,
                                            RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);

    this.runConfiguration = runConfiguration;

    this.securityScheme = securityScheme;
    this.authenticationStrategy = authenticationStrategy;
  }

  protected String getConnectionProviderXmlName() {
    return getXmlName(securityScheme.getName());
  }

  protected String getConnectionProviderBasePackage() {
    return connectorModel.getBasePackage() + ".internal.connection.provider";
  }

  protected abstract String getPackage();

  protected abstract String getJavaClassName();

  public TypeName getTypeName() {
    return ClassName.get(getPackage(), getJavaClassName());
  }
}
