/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.GET_PAGE_EXPRESSION_METHOD_NAME;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.HAS_PAGINATION_METHOD_NAME;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.SHOULD_INFER_METADATA_METHOD_NAME;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.generateGetterMethod;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils.generateReturnTrueMethod;

import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output.customfields.JsonOutputCustomFieldsHttpMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.metadata.OverrideResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;

import java.nio.file.Path;

import com.squareup.javapoet.TypeSpec;

public class SdkCustomFieldsOutputMetadataResolver extends SdkAbstractCustomFieldsMetadataResolver {

  private final boolean hasPagination;
  private final boolean shouldInferMetadata;
  private final String pageResponseExpression;

  public SdkCustomFieldsOutputMetadataResolver(Path outputDir,
                                               ConnectorModel connectorModel,
                                               SdkConnector sdkConnector,
                                               String internalName,
                                               TypeDefinition typeDefinition,
                                               String classNameOverride,
                                               OverrideResolver overrideResolver,
                                               String selector,
                                               boolean hasPagination,
                                               boolean shouldInferMetadata,
                                               String pageResponseExpression,
                                               JavaTemplateEntity parentElement,
                                               RestSdkRunConfiguration runConfiguration)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, internalName, typeDefinition, FileGenerationUtil.SchemaNameType.OUTPUT,
          classNameOverride, overrideResolver, selector, parentElement, runConfiguration);

    this.hasPagination = hasPagination;
    this.shouldInferMetadata = shouldInferMetadata;
    this.pageResponseExpression = pageResponseExpression;
  }

  @Override
  protected Class<?> buildSuperclass() throws TemplatingException {
    return JsonOutputCustomFieldsHttpMetadataResolver.class;
  }

  @Override
  protected String getClassNameSuffix() {
    return "OutputMetadataResolver";
  }

  @Override
  protected String buildGetResolverName(String internalName) {
    return internalName + "-output-type-resolver";
  }

  @Override
  protected void generateMethods(TypeSpec.Builder typeResolverClassBuilder) {
    super.generateMethods(typeResolverClassBuilder);
    if (hasPagination) {
      generateReturnTrueMethod(typeResolverClassBuilder, HAS_PAGINATION_METHOD_NAME);
    }
    if (shouldInferMetadata) {
      generateReturnTrueMethod(typeResolverClassBuilder, SHOULD_INFER_METADATA_METHOD_NAME);
      generateGetterMethod(typeResolverClassBuilder, GET_PAGE_EXPRESSION_METHOD_NAME, pageResponseExpression);
    }
  }

}
