/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;

import java.nio.file.Path;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public class SdkNativeSampleData extends JavaTemplateEntity implements SdkResolverTemplate {

  private final SampleDataDefinition sampleDataDefinition;

  public SdkNativeSampleData(Path outputDir,
                             ConnectorModel connectorModel,
                             SampleDataDefinition sampleDataDefinition,
                             RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);
    this.sampleDataDefinition = sampleDataDefinition;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    // do nothing
  }

  @Override
  public TypeName getTypeName() {
    return ClassName.bestGuess(sampleDataDefinition.getFqn().trim());
  }
}
