/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.trigger;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;

import java.nio.file.Path;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;

public class SdkNativeTrigger extends JavaTemplateEntity implements SdkTriggerTemplate {

  private final Trigger trigger;

  public SdkNativeTrigger(Path outputDir, ConnectorModel connectorModel, Trigger trigger,
                          RestSdkRunConfiguration runConfiguration) {
    super(outputDir, connectorModel, runConfiguration);
    this.trigger = trigger;
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    // do nothing
  }

  @Override
  public TypeName getTypeNameForConfig() {
    return ClassName.bestGuess(trigger.getFqn().trim());
  }
}
