/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.util;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaLowerCamelNameFromXml;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;
import static org.apache.commons.lang3.StringUtils.isNotBlank;
import static org.mule.runtime.extension.api.util.NameUtils.pluralize;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkContent;

import java.util.Optional;

public class ContentNameGenerator {

  public static String getContentName(ConnectorOperation operation,
                                      SdkMetadataResolver metadataResolver,
                                      SdkContent.SdkContentKind contentType,
                                      String partIdentifier) {

    StringBuilder xmlTypeName = new StringBuilder();
    switch (contentType) {
      case INPUT_METADATA:
        if (operation.getBody() == null) {
          throw new IllegalArgumentException("Doesn't make sense to have an input operation with a null body, seems like a bug.");
        }
        String bodyIdentifier = operation.getBody().getBodyIdentifier();
        xmlTypeName.append(getXmlName(bodyIdentifier));
        break;
      case PART:
        xmlTypeName.append(getXmlName(partIdentifier));
        break;
    }

    String javaContentName = getJavaLowerCamelNameFromXml(xmlTypeName.toString());
    return pluralizeBySchema(javaContentName, metadataResolver);
  }

  /**
   * Given a javaContentName, if the schema is an array type, then it will pluralize the name
   * 
   * @param javaContentName generated name for the content
   * @param metadataResolver input resolver for the @Content element
   * @return the content name pluralized if needed, or the {@code javaContentName} untouched
   */
  private static String pluralizeBySchema(String javaContentName, SdkMetadataResolver metadataResolver) {
    String result = javaContentName;
    String schemaName = metadataResolver.getSchemaName();
    if (isNotBlank(schemaName) && schemaName.endsWith(".json")) {
      final JsonTypeLoader jsonTypeLoader =
          new JsonTypeLoader(metadataResolver.getTypeDefinition().getTypeSchema().getRawSchema());
      final Optional<MetadataType> metadataType = jsonTypeLoader.load(null);

      if (metadataType.isPresent()) {
        if (metadataType.get() instanceof ArrayType) {
          result = pluralize(javaContentName);
        }
      }
    }
    return result;
  }
}
