/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.valueprovider;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils.getJavaUpperCamelNameFromXml;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil.getBodyFieldsFromHttpBinding;
import static com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil.isBoundParameterForHttpBinding;
import static java.util.Collections.emptyList;

import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.ExtensionsRestValueProvider;
import com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider.RestValueProvider;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingField;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProviderInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;

import java.nio.file.Path;
import java.util.List;

import com.squareup.javapoet.TypeName;

public class SdkValueProviderInline extends AbstractSdkResolverProviderInline {

  private final String parameterName;
  private final SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition;
  private final SdkValueProvidable sdkElementValueProvideable;
  private final boolean useExtensionsApi;

  public SdkValueProviderInline(Path outputDir,
                                ConnectorModel connectorModel,
                                SdkValueProvidable sdkElementValueProvideable,
                                String parameterName,
                                SdkResolverDefinition<ValueProviderDefinition> sdkResolverDefinition,
                                RestSdkRunConfiguration runConfiguration,
                                boolean useExtensionsApi) {
    super(outputDir, connectorModel, sdkResolverDefinition, runConfiguration);
    this.sdkResolverDefinition = sdkResolverDefinition;
    this.parameterName = parameterName;
    this.sdkElementValueProvideable = sdkElementValueProvideable;
    this.useExtensionsApi = useExtensionsApi;
  }

  public String getPackage() {
    return connectorModel.getBasePackage() + ".internal.metadata.values";
  }

  public String getJavaClassName() {
    return sdkElementValueProvideable.getJavaClassName() + getJavaUpperCamelNameFromXml(parameterName) + "ValueProvider";
  }

  @Override
  protected TypeName getSuperClass() {
    if (useExtensionsApi) {
      return TypeName.get(ExtensionsRestValueProvider.class);
    } else {
      return TypeName.get(RestValueProvider.class);
    }
  }

  @Override
  protected boolean isBoundParameter(SdkParameter sdkParameter) {
    return isHttpRequestBoundParameter(sdkParameter)
        || isScriptBoundParameter(sdkParameter)
        || isBoundInItems(sdkParameter);
  }

  private boolean isBoundInItems(SdkParameter sdkParameter) {
    ValueProviderDefinition definition = sdkResolverDefinition.getDefinition();
    return SdkResolverUtil.isBoundScript(sdkParameter, definition.getItemExtractionExpression())
        || SdkResolverUtil.isBoundScript(sdkParameter, definition.getItemValueExpression())
        || SdkResolverUtil.isBoundScript(sdkParameter, definition.getItemDisplayNameExpression());
  }

  private boolean isScriptBoundParameter(SdkParameter sdkParameter) {
    return SdkResolverUtil.isBoundScript(sdkParameter, sdkResolverDefinition.getDefinition().getScript());
  }

  private boolean isHttpRequestBoundParameter(SdkParameter sdkParameter) {
    if (sdkResolverDefinition.getDefinition().getRequest() == null) {
      return false;
    }
    return isBoundParameterForHttpBinding(sdkParameter,
                                          sdkResolverDefinition.getDefinition().getRequest().getHttpRequestBinding());
  }

  @Override
  protected List<SdkParameter> getAllParameters() {
    return sdkElementValueProvideable.getAllParameters();
  }

  @Override
  protected List<BindingField> getBindingFields() {
    if (sdkResolverDefinition.getDefinition().getRequest() == null) {
      return emptyList();
    }
    return getBodyFieldsFromHttpBinding(sdkResolverDefinition.getDefinition().getRequest().getHttpRequestBinding());
  }

  @Override
  protected String getEvaluationContextKind() {
    return sdkResolverDefinition.getEvaluationContextKind();
  }
}
