/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.customization;

import com.mulesoft.connectivity.rest.sdk.customization.exception.CustomizationException;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class CustomizationService {
    private DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();

    public void generateCustomizationOverlay(ConnectorModel connectorModel, Path outputDir, RestSdkRunConfiguration runConfiguration) throws CustomizationException {
        String customizationOverlay = this.generate(connectorModel);
        this.writeOutputFile(outputDir.resolve(runConfiguration.getCustomizationOverlayDir()), runConfiguration.getCustomizationOverlayFilename(), customizationOverlay.getBytes(Charset.defaultCharset()));
    }

    public String generate(ConnectorModel connectorModel) {
        DataWeaveScript compile = this.dataWeaveScriptingEngine.compile(this.readScriptFile("scripts/customization-overlay.dwl"), new String[]{"payload"});
        ScriptingBindings bindings = new ScriptingBindings().addBinding("payload", (Object)connectorModel, "application/java");
        DataWeaveResult dataWeaveResult = compile.write(bindings);
        return dataWeaveResult.getContentAsString();
    }

    private String readScriptFile(String scriptRelativePath) {
        try {
            return IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream(scriptRelativePath), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new UncheckedIOException("There was an error while reading the DataWeave script", e);
        }
    }

    private File writeOutputFile(Path outputDir, String outputFileName, byte[] content) throws CustomizationException {
        try {
            File outputFile = new File(outputDir.toFile(), outputFileName);
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])content, (boolean)false);
            return outputFile;
        }
        catch (IOException e) {
            throw new CustomizationException(String.format("There was an error while writing file '%s'", outputFileName), e);
        }
    }
}

