/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating;

import com.google.googlejavaformat.java.Formatter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.TemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkGitIgnore;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkLicense;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkLicenseHeader;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkPom;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.munit.SdkTestLog4j;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SdkConnectorTemplateEntity
extends TemplateEntity {
    private static final Logger LOGGER = LogManager.getLogger(SdkConnectorTemplateEntity.class);
    private static final Formatter FORMATTER = new Formatter();
    private final SdkConnector sdkConnector;
    private final SdkPom sdkPom;
    private final SdkTestLog4j sdkTestLog4j;
    private final Path projectDir;
    private final List<File> descriptors;
    private final SdkGitIgnore sdkGitIgnore;
    private final SdkLicense sdkLicense;
    private final SdkLicenseHeader sdkLicenseHeader;
    private final RestSdkRunConfiguration runConfiguration;

    public SdkConnectorTemplateEntity(ConnectorModel connectorModel, List<File> descriptors, RestSdkRunConfiguration runConfiguration, Path outputDir) throws TemplatingException {
        if (runConfiguration.regenerateMode()) {
            this.projectDir = outputDir;
        } else {
            String projectName = JavaUtils.getJavaUpperCamelNameFromXml((String)connectorModel.getConnectorXmlName());
            this.projectDir = outputDir.resolve(projectName);
            this.checkValidProjectDir(this.projectDir);
        }
        this.sdkConnector = new SdkConnector(this.projectDir, connectorModel, runConfiguration);
        this.sdkPom = new SdkPom(this.projectDir, connectorModel);
        this.descriptors = descriptors;
        this.sdkGitIgnore = new SdkGitIgnore(this.projectDir);
        this.sdkLicense = new SdkLicense(this.projectDir, connectorModel);
        this.sdkLicenseHeader = new SdkLicenseHeader(this.projectDir, connectorModel);
        this.sdkTestLog4j = new SdkTestLog4j(this.projectDir);
        this.runConfiguration = runConfiguration;
    }

    private void checkValidProjectDir(Path directory) throws TemplatingException {
        String[] children;
        File dirFile = directory.toFile();
        if (dirFile.exists() && dirFile.isDirectory() && (children = dirFile.list()) != null && children.length > 0) {
            throw new TemplatingException(String.format("Output directory is not empty: %s", this.projectDir.toString()));
        }
        LOGGER.info("Project output directory: " + this.projectDir.toString());
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.runConfiguration.regenerateMode()) {
            this.sdkConnector.applyTemplates();
            this.sdkLicense.applyTemplates();
            this.sdkLicenseHeader.applyTemplates();
            this.formatJavaFiles();
        } else {
            this.sdkConnector.applyTemplates();
            this.sdkPom.applyTemplates();
            this.sdkGitIgnore.applyTemplates();
            this.sdkLicense.applyTemplates();
            this.sdkLicenseHeader.applyTemplates();
            this.sdkTestLog4j.applyTemplates();
            this.formatJavaFiles();
            this.addDescriptorToSources();
        }
    }

    protected void addDescriptorToSources() throws TemplatingException {
        if (this.descriptors != null && !this.descriptors.isEmpty()) {
            int i = 1;
            for (File descriptor : this.descriptors) {
                try {
                    FileInputStream descriptorStream = new FileInputStream(descriptor);
                    Throwable throwable = null;
                    try {
                        String targetFilename = String.format("connector-descriptor%s.yaml", i > 1 ? "-" + i : "");
                        Files.copy(descriptorStream, this.sdkConnector.getSourcesPath().resolve(targetFilename), StandardCopyOption.REPLACE_EXISTING);
                        ++i;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (descriptorStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)descriptorStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)descriptorStream).close();
                    }
                }
                catch (IOException e) {
                    throw new TemplatingException("Could not add descriptor to generated sources.");
                }
            }
        }
    }

    private void formatJavaFiles() throws TemplatingException {
        for (Path path : this.getJavaFiles()) {
            this.javaFormat(path);
        }
    }

    private List<Path> getJavaFiles() throws TemplatingException {
        List sourcesList = Arrays.asList(this.runConfiguration.getGeneratedSourcesDir(), this.runConfiguration.getIgnoredDir()).stream().filter(Objects::nonNull).map(p -> this.projectDir.resolve((String)p)).collect(Collectors.toList());
        ArrayList<Path> collect = new ArrayList<Path>();
        for (Path source : sourcesList) {
            try {
                if (!Files.exists(source, new LinkOption[0])) continue;
                Stream<Path> paths = Files.find(source, Integer.MAX_VALUE, (filePath, fileAttr) -> filePath.toString().toLowerCase().endsWith(".java"), new FileVisitOption[0]);
                collect.addAll(paths.collect(Collectors.toList()));
            }
            catch (Exception e) {
                throw new TemplatingException("Could not find files to format. This is a bug.", e);
            }
        }
        return collect;
    }

    private void javaFormat(Path filepath) throws TemplatingException {
        try {
            String content = new String(Files.readAllBytes(filepath), StandardCharsets.UTF_8);
            String formattedSource = FORMATTER.formatSource(content);
            Files.delete(filepath);
            Files.write(filepath, formattedSource.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new TemplatingException(String.format("Could not format file '%s'.", filepath.toString()), e);
        }
    }
}

