/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.MockedConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.MockedAuthenticationScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.AbstractSdkConnectionProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.connection.layers.AbstractSdkConnectionProviderLayer;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang.WordUtils;
import org.mule.runtime.extension.api.annotation.Alias;

public class SdkMockedConnectionProvider
extends AbstractSdkConnectionProvider {
    private final MockedAuthenticationScheme securityScheme;
    private final SdkMockedConnectionProviderLayer sdkMockedConnectionProviderLayer;

    public SdkMockedConnectionProvider(Path outputDir, ConnectorModel connectorModel, MockedAuthenticationScheme securityScheme, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.securityScheme = securityScheme;
        this.sdkMockedConnectionProviderLayer = new SdkMockedConnectionProviderLayer(outputDir, connectorModel, (ConnectorSecurityScheme)securityScheme, runConfiguration);
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.sdkMockedConnectionProviderLayer.applyTemplates();
    }

    @Override
    public TypeName getTypeNameForConfig() {
        return ClassName.get((String)this.sdkMockedConnectionProviderLayer.getPackage(), (String)this.sdkMockedConnectionProviderLayer.getJavaClassName(), (String[])new String[0]);
    }

    private class SdkMockedConnectionProviderLayer
    extends AbstractSdkConnectionProviderLayer {
        private final String MOCKED_JAVADOC = "Auto generated mocked connection provider.";
        private final String MOCKED = "Mocked";

        public SdkMockedConnectionProviderLayer(Path outputDir, ConnectorModel connectorModel, ConnectorSecurityScheme securityScheme, RestSdkRunConfiguration runConfiguration) {
            super(outputDir, connectorModel, securityScheme, null, runConfiguration);
            this.MOCKED_JAVADOC = "Auto generated mocked connection provider.";
            this.MOCKED = "Mocked";
        }

        @Override
        public void applyTemplates() throws TemplatingException {
            this.generateMockedConnectionProviderClass();
        }

        @Override
        protected String getPackage() {
            return this.getConnectionProviderBasePackage();
        }

        @Override
        protected String getJavaClassName() {
            return JavaUtils.getJavaUpperCamelNameFromXml((String)this.getConnectionProviderXmlName()) + "Mocked" + "ConnectionProvider";
        }

        private void generateMockedConnectionProviderClass() throws TemplatingException {
            TypeSpec.Builder connectionProviderClassBuilder = TypeSpec.classBuilder((String)this.getJavaClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(MockedConnectionProvider.class).addAnnotation(this.generateAliasAnnotation()).addAnnotation(SdkTemplatingUtils.getDisplayNameAnnotation(this.getConnectionProviderDisplayName())).addJavadoc("Auto generated mocked connection provider.", new Object[0]);
            this.writeClassToFile(connectionProviderClassBuilder.build(), this.getPackage());
        }

        private AnnotationSpec generateAliasAnnotation() {
            return AnnotationSpec.builder(Alias.class).addMember("value", "$S", new Object[]{WordUtils.capitalize((String)(this.getConnectionProviderXmlName() + "Mocked"))}).build();
        }

        private String getConnectionProviderDisplayName() {
            return WordUtils.capitalize((String)(this.getConnectionProviderXmlName() + " " + "Mocked").replace('-', ' ')) + " Connection Provider";
        }
    }
}

