/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import com.mulesoft.connectivity.rest.commons.api.binding.HttpRequestBinding;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.EvaluationContextBuilderFactory;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.metadata.OverrideResolver;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.operation.AbstractSdkOperation;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.SdkTemplatingUtils;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;

public abstract class SdkAbstractCustomFieldsMetadataResolver
extends JavaTemplateEntity
implements SdkMetadataResolver {
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private static final String GET_RESOLVER_NAME_METHOD_NAME = "getResolverName";
    private static final String GET_SCHEMA_PATH_METHOD_NAME = "getSchemaPath";
    private static final String GET_METHOD_METHOD_NAME = "getMethod";
    private static final String GET_PATH_METHOD_NAME = "getPath";
    private static final String GET_TRANSFORMATION_SCRIPT_METHOD_NAME = "getTransformationScript";
    private static final String GET_SELECTOR_METHOD_NAME = "getSelector";
    private static final String GET_REQUEST_BINDINGS_METHOD_NAME = "getRequestBindings";
    private static final String ADD_URI_BINDING_METHOD = "addUriParamBinding";
    private static final String ADD_QUERY_BINDING_METHOD = "addQueryParamBinding";
    private static final String ADD_HEADER_BINDING_METHOD = "addHeaderBinding";
    private static final String BINDINGS_VAR = "bindings";
    private TypeDefinition typeDefinition;
    private TypeName typeName;
    private String internalName;
    private final String schemaName;
    private final String schemaPath;
    private final OverrideResolver overrideResolver;
    private final String selector;
    private final String className;
    private final String javaPackage;
    private final JavaTemplateEntity parentElement;
    protected Class<?> superclass;

    public SdkAbstractCustomFieldsMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String internalName, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType, String classNameOverride, OverrideResolver overrideResolver, String selector, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.typeDefinition = typeDefinition;
        this.typeName = sdkConnector.getTypeName();
        this.internalName = internalName;
        this.overrideResolver = overrideResolver;
        this.selector = selector;
        this.parentElement = parentElement;
        this.superclass = this.buildSuperclass();
        this.schemaName = this.processSchemaName(sdkConnector, internalName, typeDefinition, schemaNameType);
        this.className = this.buildClassName(internalName, classNameOverride);
        this.javaPackage = this.buildPackage(connectorModel);
        Path schemaOutputDir = sdkConnector.getResourcesPath().resolve(runConfiguration.getGeneratedSchemasDir());
        FileGenerationUtil.writeSchema(typeDefinition.getTypeSchema(), schemaOutputDir, this.schemaName);
        this.schemaPath = "/" + runConfiguration.getGeneratedSchemasDir() + "/" + this.schemaName;
    }

    protected abstract Class<?> buildSuperclass() throws TemplatingException;

    protected abstract String getClassNameSuffix();

    protected abstract String buildGetResolverName(String var1);

    private String processSchemaName(SdkConnector sdkConnector, String internalName, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType) {
        Map<TypeSchema, String> typeSchemaNames = sdkConnector.getTypeSchemaNames();
        TypeSchema source = typeDefinition.getTypeSchema();
        return typeSchemaNames.computeIfAbsent(source, typeSchema -> FileGenerationUtil.generateSchemaName(source, internalName, schemaNameType, ""));
    }

    private String buildClassName(String internalName, String classNameOverride) {
        if (StringUtils.isBlank((CharSequence)classNameOverride)) {
            return JavaUtils.getJavaUpperCamelNameFromXml((String)internalName) + this.getClassNameSuffix();
        }
        return JavaUtils.getJavaUpperCamelNameFromXml((String)XmlUtils.getXmlName((String)classNameOverride)) + this.getClassNameSuffix();
    }

    private String buildPackage(ConnectorModel connectorModel) {
        return connectorModel.getBasePackage() + ".internal.metadata";
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        this.generateMetadataResolverClass();
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getPackage() {
        return this.javaPackage;
    }

    @Override
    public boolean getRequiresMetadataResolver() {
        return true;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    private void generateMetadataResolverClass() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass);
        this.generateMethods(typeResolverClassBuilder);
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    protected void generateMethods(TypeSpec.Builder typeResolverClassBuilder) {
        this.generateGetCategoryNameMethod(typeResolverClassBuilder);
        SdkTemplatingUtils.generateGetterMethod(typeResolverClassBuilder, GET_RESOLVER_NAME_METHOD_NAME, this.buildGetResolverName(this.internalName));
        SdkTemplatingUtils.generateGetterMethod(typeResolverClassBuilder, GET_SCHEMA_PATH_METHOD_NAME, this.schemaPath);
        SdkTemplatingUtils.generateGetterMethod(typeResolverClassBuilder, GET_METHOD_METHOD_NAME, this.overrideResolver.getRequest().getMethod().toString());
        SdkTemplatingUtils.generateGetterMethod(typeResolverClassBuilder, GET_PATH_METHOD_NAME, this.overrideResolver.getRequest().getPath());
        SdkTemplatingUtils.generateGetterMethod(typeResolverClassBuilder, GET_TRANSFORMATION_SCRIPT_METHOD_NAME, this.overrideResolver.getTransformationScript());
        SdkTemplatingUtils.generateGetterMethod(typeResolverClassBuilder, GET_SELECTOR_METHOD_NAME, this.selector);
        if (this.overrideResolver.getRequest().getHttpRequestBinding() != null) {
            this.generateGetRequestBindingsMethod(typeResolverClassBuilder, this.overrideResolver.getRequest().getHttpRequestBinding());
            this.generateBuildEvaluationContextMethod(typeResolverClassBuilder, this.overrideResolver.getRequest().getHttpRequestBinding());
        }
    }

    private void generateGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock getCategoryCodeBlock = CodeBlock.builder().addStatement("return $T.API_METADATA_CATEGORY", new Object[]{this.typeName}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(getCategoryCodeBlock).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void generateGetRequestBindingsMethod(TypeSpec.Builder typeResolverClassBuilder, com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding httpRequestBinding) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_REQUEST_BINDINGS_METHOD_NAME).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(TypeName.get(HttpRequestBinding.class)).addAnnotation(Override.class);
        methodBuilder.addStatement("$1T $2L = new $1T()", new Object[]{HttpRequestBinding.class, BINDINGS_VAR});
        for (Argument binding : httpRequestBinding.getQueryParameter()) {
            this.addBinding(methodBuilder, binding, ADD_QUERY_BINDING_METHOD);
        }
        for (Argument binding : httpRequestBinding.getUriParameter()) {
            this.addBinding(methodBuilder, binding, ADD_URI_BINDING_METHOD);
        }
        for (Argument binding : httpRequestBinding.getHeader()) {
            this.addBinding(methodBuilder, binding, ADD_HEADER_BINDING_METHOD);
        }
        methodBuilder.addStatement("return $1L", new Object[]{BINDINGS_VAR});
        typeResolverClassBuilder.addMethod(methodBuilder.build());
    }

    private void addBinding(MethodSpec.Builder methodBuilder, Argument binding, String bindingMethod) {
        methodBuilder.addStatement("$L.$L($S, $S)", new Object[]{BINDINGS_VAR, bindingMethod, binding.getName(), binding.getValue().getValue()});
    }

    private void generateBuildEvaluationContextMethod(TypeSpec.Builder typeResolverClassBuilder, com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding httpRequestBinding) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"buildEvaluationContext").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(EvaluationContext.class).addParameter(TypeName.get(EvaluationContextBuilderFactory.class), "builderFactory", new Modifier[0]).addParameter(TypeName.get(Object.class), "key", new Modifier[0]).addAnnotation(Override.class);
        this.addParameterBindings(methodBuilder, ((AbstractSdkOperation)this.parentElement).getAllParameters(), httpRequestBinding);
        typeResolverClassBuilder.addMethod(methodBuilder.build());
    }

    private void addParameterBindings(MethodSpec.Builder methodBuilder, List<SdkParameter> parameters, com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding httpRequestBinding) {
        CodeBlock.Builder contextBindingBuilder = CodeBlock.builder();
        contextBindingBuilder.add("return builderFactory.operationContextBuilder()", new Object[0]);
        for (SdkParameter sdkParameter : parameters) {
            if (!SdkResolverUtil.isBoundParameterForHttpBinding(sdkParameter, httpRequestBinding)) continue;
            contextBindingBuilder.add(".$1L($2S, $3L)", new Object[]{sdkParameter.getParameterType().getAccessorName(), sdkParameter.getExternalName(), "key"});
        }
        contextBindingBuilder.add(".build()", new Object[0]);
        methodBuilder.addStatement(contextBindingBuilder.build());
    }
}

