/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.EmptyTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.JavaUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.exception.TemplatingException;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.metadata.SdkMetadataResolver;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.util.FileGenerationUtil;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.nio.file.Path;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataFormat;

public abstract class SdkAbstractStaticMetadataResolver
extends JavaTemplateEntity
implements SdkMetadataResolver {
    private final TypeDefinition typeDefinition;
    private static final String GET_SCHEMA_PATH_METHOD_NAME = "getSchemaPath";
    private static final String GET_RESOLVER_NAME_METHOD_NAME = "getResolverName";
    private static final String GET_CATEGORY_NAME_METHOD_NAME = "getCategoryName";
    private static final String GET_QNAME_METHOD_NAME = "getQName";
    private static final String GET_FORMAT_METHOD_NAME = "getFormat";
    private final boolean requiresMetadataResolver;
    private final boolean requiresToWriteSchema;
    private String schemaName;
    private String schemaPath;
    private String className;
    private String javaPackage;
    private CodeBlock getResolverNameCodeBlock;
    private CodeBlock getCategoryCodeBlock;
    protected Class<?> superclass;

    public SdkAbstractStaticMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String internalName, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType, String partName, String classNameOverride, RestSdkRunConfiguration runConfiguration) throws TemplatingException {
        super(outputDir, connectorModel, runConfiguration);
        this.typeDefinition = typeDefinition;
        this.superclass = this.buildSuperclass(typeDefinition);
        this.requiresMetadataResolver = this.buildRequiresMetadataResolver();
        this.requiresToWriteSchema = this.requiresToWriteSchema();
        if (FileGenerationUtil.supportsSchemaGeneration(typeDefinition.getTypeSchema())) {
            this.schemaName = this.processSchemaName(sdkConnector, internalName, typeDefinition, schemaNameType, partName);
            if (this.requiresMetadataResolver) {
                this.className = this.buildClassName(internalName, partName, classNameOverride);
                this.javaPackage = this.buildPackage(connectorModel);
                this.getCategoryCodeBlock = CodeBlock.builder().addStatement("return $T.API_METADATA_CATEGORY", new Object[]{sdkConnector.getTypeName()}).build();
                this.getResolverNameCodeBlock = CodeBlock.builder().addStatement("return $S", new Object[]{this.buildGetResolverName(internalName)}).build();
                if (this.requiresToWriteSchema) {
                    Path schemaOutputDir = sdkConnector.getResourcesPath().resolve(runConfiguration.getGeneratedSchemasDir());
                    FileGenerationUtil.writeSchema(typeDefinition.getTypeSchema(), schemaOutputDir, this.schemaName);
                    this.schemaPath = "/" + runConfiguration.getGeneratedSchemasDir() + "/" + this.schemaName;
                }
            }
        }
    }

    protected abstract String buildGetResolverName(String var1);

    private String processSchemaName(SdkConnector sdkConnector, String internalName, TypeDefinition typeDefinition, FileGenerationUtil.SchemaNameType schemaNameType, String partName) {
        Map<TypeSchema, String> typeSchemaNames = sdkConnector.getTypeSchemaNames();
        TypeSchema source = typeDefinition.getTypeSchema();
        return typeSchemaNames.computeIfAbsent(source, typeSchema -> this.getSchemaName(internalName, schemaNameType, source, partName));
    }

    protected String getSchemaName(String internalName, FileGenerationUtil.SchemaNameType schemaNameType, TypeSchema source, String partName) {
        return FileGenerationUtil.generateSchemaName(source, internalName, schemaNameType, partName);
    }

    protected abstract Class<?> buildSuperclass(TypeDefinition var1) throws TemplatingException;

    protected abstract String getClassNameSuffix();

    private String buildClassName(String internalName, String partName, String classNameOverride) {
        if (StringUtils.isBlank((CharSequence)classNameOverride)) {
            return JavaUtils.getJavaUpperCamelNameFromXml((String)internalName) + (StringUtils.isNotBlank((CharSequence)partName) ? JavaUtils.getJavaUpperCamelNameFromXml((String)XmlUtils.getXmlName((String)partName)) : "") + this.getClassNameSuffix();
        }
        return JavaUtils.getJavaUpperCamelNameFromXml((String)XmlUtils.getXmlName((String)classNameOverride)) + this.getClassNameSuffix();
    }

    private String buildPackage(ConnectorModel connectorModel) {
        return connectorModel.getBasePackage() + ".internal.metadata";
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getPackage() {
        return this.javaPackage;
    }

    @Override
    public void applyTemplates() throws TemplatingException {
        if (this.requiresMetadataResolver) {
            this.generateMetadataResolverClass();
        }
    }

    private void generateMetadataResolverClass() throws TemplatingException {
        TypeSpec.Builder typeResolverClassBuilder = TypeSpec.classBuilder((String)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass(this.superclass);
        this.generateMethods(typeResolverClassBuilder);
        this.writeClassToFile(typeResolverClassBuilder.build(), this.javaPackage);
    }

    protected void generateMethods(TypeSpec.Builder typeResolverClassBuilder) {
        if (this.requiresToWriteSchema) {
            this.addGetSchemaPathMethod(typeResolverClassBuilder);
        }
        this.addGetResolverNameMethod(typeResolverClassBuilder);
        this.addGetCategoryNameMethod(typeResolverClassBuilder);
        if (this.requiresQNameMethod()) {
            this.addGetQNameMethod(typeResolverClassBuilder);
        }
        if (this.requiresFormatMethod()) {
            this.addFormatMethod(typeResolverClassBuilder);
        }
    }

    private void addFormatMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return new $1T($2S, $2S, $2S)", new Object[]{MetadataFormat.class, this.typeDefinition.getMediaType().getType() + "/" + this.typeDefinition.getMediaType().getSubtype()}).build();
        MethodSpec formatMethod = MethodSpec.methodBuilder((String)GET_FORMAT_METHOD_NAME).returns(TypeName.get(MetadataFormat.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(formatMethod);
    }

    private void addGetSchemaPathMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.schemaPath}).build();
        MethodSpec createConnectionMethod = MethodSpec.methodBuilder((String)GET_SCHEMA_PATH_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(createConnectionMethod);
    }

    private void addGetResolverNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_RESOLVER_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(this.getResolverNameCodeBlock).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void addGetCategoryNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_CATEGORY_NAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(this.getCategoryCodeBlock).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    private void addGetQNameMethod(TypeSpec.Builder typeResolverClassBuilder) {
        CodeBlock methodBody = CodeBlock.builder().addStatement("return $S", new Object[]{this.getQName()}).build();
        MethodSpec getCategoryNameMethod = MethodSpec.methodBuilder((String)GET_QNAME_METHOD_NAME).returns(TypeName.get(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addCode(methodBody).build();
        typeResolverClassBuilder.addMethod(getCategoryNameMethod);
    }

    protected abstract boolean requiresQNameMethod();

    protected abstract boolean requiresFormatMethod();

    protected abstract String getQName();

    protected boolean buildRequiresMetadataResolver() {
        return !(this.typeDefinition instanceof EmptyTypeDefinition);
    }

    @Override
    public boolean getRequiresMetadataResolver() {
        return this.requiresMetadataResolver;
    }

    protected abstract boolean requiresToWriteSchema();

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }
}

