/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationKind;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.PrimitiveTypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.JavaTemplateEntity;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import java.nio.file.Path;

public class SdkPaginationParameter
extends SdkParameter {
    private final Pagination pagination;

    public SdkPaginationParameter(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, String parentJavaName, Parameter parameter, JavaTemplateEntity parentElement, RestSdkRunConfiguration runConfiguration, Pagination pagination) {
        super(outputDir, connectorModel, sdkConnector, parentJavaName, parameter, parentElement, runConfiguration);
        this.pagination = pagination;
    }

    @Override
    protected TypeDefinition getTypeDefinition() {
        TypeDefinition paginationParameterType = TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)PrimitiveTypeDefinition.PrimitiveType.INTEGER);
        if (this.pagination.getKind().equals((Object)PaginationKind.MARKER)) {
            paginationParameterType = TypeDefinition.simplePrimitiveType((PrimitiveTypeDefinition.PrimitiveType)PrimitiveTypeDefinition.PrimitiveType.STRING);
        }
        return paginationParameterType;
    }

    @Override
    public String getDefaultValue() {
        if (this.pagination.getKind().equals((Object)PaginationKind.PAGE_NUMBER)) {
            return this.pagination.getInitialPageNumber();
        }
        if (this.pagination.getKind().equals((Object)PaginationKind.OFFSET)) {
            return this.pagination.getInitialOffset();
        }
        return super.getDefaultValue();
    }
}

