/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver;

import com.mulesoft.connectivity.rest.commons.internal.model.common.DataType;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.SimpleEvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverDeclaration;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.AbstractSdkResolverProvider;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverDefinition;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public abstract class AbstractSdkResolverProviderReferenceParent
extends AbstractSdkResolverProvider {
    public static final String GLOBAL_EVALUATION_CONTEXT_FIELD = "globalEvaluationContext";
    public static final String GET_RESOLVER_DECLARATION_METHOD = "getResolverDeclaration";
    public static final String GET_GLOBAL_EVALUATION_CONTEXT_METHOD = "getGlobalEvaluationContext";
    public static final String RESOLVER_NAME_FIELD = "RESOLVER_NAME";
    private final ResolverReference<?> resolverReference;
    private final SdkResolverDefinition<?> sdkResolverDefinition;

    public AbstractSdkResolverProviderReferenceParent(Path outputDir, ConnectorModel connectorModel, ResolverReference<?> resolverReference, SdkResolverDefinition<?> sdkResolverDefinition, RestSdkRunConfiguration runConfiguration) {
        super(outputDir, connectorModel, runConfiguration);
        this.resolverReference = resolverReference;
        this.sdkResolverDefinition = sdkResolverDefinition;
    }

    @Override
    public TypeName getTypeName() {
        return ClassName.get((String)this.getPackage(), (String)this.getJavaClassName(), (String[])new String[0]);
    }

    @Override
    protected void buildClass(TypeSpec.Builder classBuilder) {
        classBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT}).addField(this.generateGlobalContextField()).addField(this.getResolverNameField()).addMethod(this.generateGetGlobalEvaluationContext()).addMethod(this.generateGetResolverDeclaration()).addModifiers(new Modifier[]{Modifier.ABSTRACT});
        this.sdkResolverDefinition.addClassConstants(classBuilder);
    }

    private MethodSpec generateGetGlobalEvaluationContext() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_GLOBAL_EVALUATION_CONTEXT_METHOD).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{EvaluationContext.class})).addAnnotation(Override.class);
        methodBuilder.beginControlFlow("if ($L != null)", new Object[]{GLOBAL_EVALUATION_CONTEXT_FIELD}).addStatement("return $T.of($L)", new Object[]{Optional.class, GLOBAL_EVALUATION_CONTEXT_FIELD}).endControlFlow().addStatement("$L = new $T()", new Object[]{GLOBAL_EVALUATION_CONTEXT_FIELD, SimpleEvaluationContext.class}).addStatement("$L.declare($L())", new Object[]{GLOBAL_EVALUATION_CONTEXT_FIELD, GET_RESOLVER_DECLARATION_METHOD}).addStatement("return $T.of($L)", new Object[]{Optional.class, GLOBAL_EVALUATION_CONTEXT_FIELD});
        return methodBuilder.build();
    }

    private MethodSpec generateGetResolverDeclaration() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)GET_RESOLVER_DECLARATION_METHOD).returns((TypeName)ParameterizedTypeName.get(ResolverDeclaration.class, (Type[])new Type[]{this.sdkResolverDefinition.getSdkResolverDefinitionClass()})).addModifiers(new Modifier[]{Modifier.PRIVATE});
        methodBuilder.addStatement("$1T builder = new $1T($2L)", new Object[]{this.sdkResolverDefinition.getSdkResolverDeclarationBuilderClass(), RESOLVER_NAME_FIELD});
        CodeBlock.Builder builderBuilder = this.sdkResolverDefinition.getResolverExpressionBuilder();
        for (ResolverParameter resolverParameter : this.resolverReference.getDeclaration().getParameters()) {
            String dataType = DataType.fromString((String)resolverParameter.getType().getName()).name().toUpperCase();
            builderBuilder.add(".parameter($S, p -> p.type($T.$L))", new Object[]{resolverParameter.getName(), DataType.class, dataType});
        }
        methodBuilder.addStatement(builderBuilder.build()).addStatement("return builder.build()", new Object[0]);
        return methodBuilder.build();
    }

    private FieldSpec getResolverNameField() {
        return FieldSpec.builder(String.class, (String)RESOLVER_NAME_FIELD, (Modifier[])new Modifier[]{Modifier.PROTECTED, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.resolverReference.getDeclaration().getName()}).build();
    }

    private FieldSpec generateGlobalContextField() {
        return FieldSpec.builder((TypeName)ClassName.get(EvaluationContext.class), (String)GLOBAL_EVALUATION_CONTEXT_FIELD, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
    }
}

