/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorModel;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.templating.api.RestSdkRunConfiguration;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.SdkConnector;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.parameter.SdkParameter;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.resolver.SdkResolverTemplate;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkNativeSampleData;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataInline;
import com.mulesoft.connectivity.rest.sdk.templating.sdk.sampledata.SdkSampleDataReference;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SdkSampleDataFactory {
    public static SdkResolverTemplate getSdkSampleDataResolver(ConnectorOperation operation, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, List<SdkParameter> allParameters, Path outputDir, RestSdkRunConfiguration runConfiguration) {
        ResolverExpression sampleData = operation.getSampleData();
        if (sampleData == null) {
            return null;
        }
        return SdkSampleDataFactory.getSdkSampleDataResolver(connectorModel, sdkConnector, javaClassName, allParameters, outputDir, runConfiguration, (ResolverExpression<SampleDataDefinition>)sampleData, operation.hasPagination(), false);
    }

    public static SdkResolverTemplate getSdkSampleDataResolver(Trigger trigger, ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, List<SdkParameter> allParameters, Path outputDir, RestSdkRunConfiguration runConfiguration) {
        ResolverExpression sampleData = trigger.getSampleData();
        if (sampleData == null) {
            return null;
        }
        return SdkSampleDataFactory.getSdkSampleDataResolver(connectorModel, sdkConnector, javaClassName, allParameters, outputDir, runConfiguration, (ResolverExpression<SampleDataDefinition>)sampleData, false, true);
    }

    private static SdkResolverTemplate getSdkSampleDataResolver(ConnectorModel connectorModel, SdkConnector sdkConnector, String javaClassName, List<SdkParameter> allParameters, Path outputDir, RestSdkRunConfiguration runConfiguration, ResolverExpression<SampleDataDefinition> sampleData, boolean isPaginated, boolean isTrigger) {
        if (sampleData instanceof SampleDataDefinition) {
            SampleDataDefinition sampleDataDefinition = (SampleDataDefinition)sampleData;
            if (StringUtils.isNotBlank((CharSequence)sampleDataDefinition.getFqn())) {
                return new SdkNativeSampleData(outputDir, connectorModel, sampleDataDefinition, runConfiguration);
            }
            return new SdkSampleDataInline(outputDir, connectorModel, javaClassName, allParameters, new SdkSampleDataDefinition(sampleData, isTrigger, isPaginated), runConfiguration);
        }
        if (sampleData instanceof ResolverReference) {
            return new SdkSampleDataReference(outputDir, connectorModel, sdkConnector, javaClassName, allParameters, (ResolverReference<SampleDataDefinition>)((ResolverReference)sampleData), new SdkSampleDataDefinition(sampleData, isTrigger, isPaginated), runConfiguration);
        }
        throw new IllegalArgumentException(String.format("Type not supported for Sdk Sample Data generation [%s]", sampleData.getClass()));
    }
}

